/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.internal;

import ar.com.zauber.commons.mom.MapObjectMapper;
import ar.com.zauber.commons.mom.MapObjectMapperBuilder;
import ar.com.zauber.commons.mom.MapObjectMapperInterceptor;
import ar.com.zauber.commons.mom.converter.CompositeTypeConverter;
import ar.com.zauber.commons.mom.converter.IdentityTypeConverter;
import ar.com.zauber.commons.mom.converter.TypeConverter;
import ar.com.zauber.commons.mom.internal.DefaultMapObjectMapper;
import ar.com.zauber.commons.mom.internal.InterceptingMapObjectMapper;
import ar.com.zauber.commons.mom.style.SetterStyle;
import ar.com.zauber.commons.mom.style.impl.BeanStyle;
import java.util.LinkedList;
import java.util.List;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public class DefaultMapObjectMapperBuilder
implements MapObjectMapperBuilder {
    private final String packageName;
    private SetterStyle setterStyle;
    private List<TypeConverter> converters;
    private MapObjectMapperInterceptor interceptor;

    public DefaultMapObjectMapperBuilder(@NotEmpty String packageName) {
        Ensure.that().isNotEmpty("var0", (CharSequence)packageName);
        this.setterStyle = BeanStyle.STYLE;
        this.converters = new LinkedList<TypeConverter>();
        this.interceptor = null;
        this.packageName = packageName;
        this.withConverter(IdentityTypeConverter.converter());
    }

    @Override
    @ForceRestrictions
    public MapObjectMapperBuilder withSetterStyle(@NonNull SetterStyle style) {
        Ensure.isNotNull((String)"var0", (Object)style);
        this.setterStyle = style;
        return this;
    }

    @Override
    @ForceRestrictions
    public MapObjectMapperBuilder withConverter(@NonNull TypeConverter converter) {
        Ensure.isNotNull((String)"var0", (Object)converter);
        this.converters.add(converter);
        return this;
    }

    @Override
    @ForceRestrictions
    public MapObjectMapperBuilder withInterceptor(@NonNull MapObjectMapperInterceptor inter) {
        Ensure.isNotNull((String)"var0", (Object)inter);
        this.interceptor = inter;
        return this;
    }

    @Override
    public MapObjectMapper build() {
        if (this.interceptor == null) {
            return new DefaultMapObjectMapper(this.packageName, this.setterStyle, this.typeConverter());
        }
        return new InterceptingMapObjectMapper(this.packageName, this.setterStyle, this.typeConverter(), this.interceptor);
    }

    private CompositeTypeConverter typeConverter() {
        return new CompositeTypeConverter(this.converters);
    }
}

