/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.internal;

import ar.com.zauber.commons.mom.AbstractMapObjectMapper;
import ar.com.zauber.commons.mom.converter.TypeConverter;
import ar.com.zauber.commons.mom.internal.AttributesMap;
import ar.com.zauber.commons.mom.internal.MappingPackage;
import ar.com.zauber.commons.mom.internal.StructureType;
import ar.com.zauber.commons.mom.style.SetterStyle;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public class DefaultMapObjectMapper
extends AbstractMapObjectMapper {
    private final MappingPackage mappingPackage;
    private final SetterStyle setterStyle;
    private TypeConverter typeConverter;

    public DefaultMapObjectMapper(@NonNull String packageName, @NonNull SetterStyle setterStyle, @NonNull TypeConverter typeConverter) {
        Ensure.isNotNull((String)"var2", (Object)typeConverter);
        Ensure.isNotNull((String)"var1", (Object)setterStyle);
        Ensure.isNotNull((String)"var0", (Object)packageName);
        this.mappingPackage = new MappingPackage(packageName);
        this.setterStyle = setterStyle;
        this.typeConverter = typeConverter;
    }

    @Override
    @ForceRestrictions
    public boolean isCompositeType(@NonNull Class<?> clazz) {
        Ensure.isNotNull((String)"var0", clazz);
        return this.mappingPackage.isMappeable(clazz);
    }

    @Override
    protected Map<String, Object> mapObjectImpl(Object value) {
        Ensure.that((boolean)this.isCompositeType(value.getClass()), (String)"%s must be a composite type", (Object[])new Object[]{value});
        return new AttributesMap(value, this);
    }

    @Override
    protected Object coerce(Object value, Class<?> type) {
        return this.typeConverter.convert(value, type);
    }

    @Override
    protected <A> A unmapMapImpl(Map<String, Object> map, Class<A> targetType) {
        try {
            A bean = targetType.newInstance();
            this.unmapProperties(map, bean);
            return bean;
        }
        catch (Exception e) {
            throw SoftException.soften((Exception)e);
        }
    }

    protected void unmapProperties(@NonNull Map<String, Object> source, @NonNull Object destination) throws IllegalAccessException, InvocationTargetException {
        for (Map.Entry<String, Object> property : source.entrySet()) {
            if (property.getKey().equals("__javaType")) continue;
            this.unmapProperty(property.getValue(), destination, property.getKey());
        }
    }

    protected void unmapProperty(Object propertyValue, Object destination, String propertyName) {
        Class targetType = StructureType.getStructureType(destination, propertyName);
        try {
            this.setterStyle.setValue(destination, propertyName, this.unmap(propertyValue, targetType));
        }
        catch (Exception e) {
            throw SoftException.soften((Exception)e);
        }
    }
}

