/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleModule;
import org.mule.runtime.core.util.CollectionUtils;
import org.mule.runtime.core.util.JdkVersionUtils;
import org.mule.runtime.core.util.PropertiesUtils;

public class JreModuleDiscoverer
implements ModuleDiscoverer {
    protected static final String JRE_PACKAGES_PROPERTIES = "jre-packages.properties";
    protected static final String JRE_MODULE_NAME = "jre";
    public static final String UNABLE_TO_DETERMINE_JRE_PACKAGES_ERROR = "Unable to determine packages exported by the JRE";

    @Override
    public List<MuleModule> discover() {
        return CollectionUtils.singletonList((Object)new MuleModule(JRE_MODULE_NAME, this.loadJrePackages(), Collections.emptySet()));
    }

    private HashSet<String> loadJrePackages() {
        try {
            Properties properties = PropertiesUtils.loadProperties((URL)this.getClass().getClassLoader().getResource(JRE_PACKAGES_PROPERTIES));
            String jreVersionProperty = this.getJreVersionProperty();
            if (!properties.keySet().contains(jreVersionProperty)) {
                throw new IllegalStateException(UNABLE_TO_DETERMINE_JRE_PACKAGES_ERROR);
            }
            String packages = (String)properties.get(jreVersionProperty);
            HashSet<String> result = new HashSet<String>();
            for (String jrePackage : packages.split(",")) {
                if (StringUtils.isEmpty((String)(jrePackage = jrePackage.trim()))) continue;
                result.add(jrePackage);
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to determine JRE provided packages", e);
        }
    }

    private String getJreVersionProperty() {
        JdkVersionUtils.JdkVersion jdkVersion = JdkVersionUtils.getJdkVersion();
        return "jre-" + jdkVersion.getMajor() + "." + jdkVersion.getMinor();
    }
}

