/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.client.remoting;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.component.SimpleCallableJavaComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.message.DefaultExceptionPayload;
import org.mule.model.seda.SedaService;
import org.mule.module.client.i18n.ClientMessages;
import org.mule.module.client.remoting.ServerHandshake;
import org.mule.module.client.remoting.notification.RemoteDispatcherNotification;
import org.mule.object.SingletonObjectFactory;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;
import org.mule.util.MapUtils;

@Deprecated
public class RemoteDispatcherComponent
implements Callable,
Initialisable {
    protected static final Log logger = LogFactory.getLog(RemoteDispatcherComponent.class);
    public static final String MANAGER_COMPONENT_NAME = "_muleManagerComponent";
    protected WireFormat wireFormat;
    protected String encoding;
    protected int synchronousEventTimeout = 5000;
    protected InboundEndpoint inboundEndpoint;
    protected MuleContext muleContext;

    public RemoteDispatcherComponent(InboundEndpoint inboundEndpoint, WireFormat wireFormat, String encoding, int synchronousEventTimeout) {
        this.inboundEndpoint = inboundEndpoint;
        this.wireFormat = wireFormat;
        this.encoding = encoding;
        this.synchronousEventTimeout = synchronousEventTimeout;
    }

    public void initialise() throws InitialisationException {
        if (this.inboundEndpoint == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"inboundEndpoint"), (Initialisable)this);
        }
        if (this.wireFormat == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"wireFormat"), (Initialisable)this);
        }
    }

    public Object onCall(MuleEventContext context) throws Exception {
        this.muleContext = context.getMuleContext();
        byte[] messageBytes = (byte[])context.transformMessage(byte[].class);
        if (new String(messageBytes).equals("MULE_CLIENT_HANDSHAKE")) {
            return this.doHandshake(context);
        }
        logger.debug((Object)"Message received by RemoteDispatcherComponent");
        ByteArrayInputStream in = new ByteArrayInputStream((byte[])context.transformMessage(DataType.BYTE_ARRAY_DATA_TYPE));
        RemoteDispatcherNotification action = (RemoteDispatcherNotification)((Object)((MuleMessage)this.wireFormat.read((InputStream)in)).getPayload());
        if (action.getMessage() != null) {
            Method m = action.getMessage().getClass().getDeclaredMethod("initAfterDeserialisation", MuleContext.class);
            m.setAccessible(true);
            m.invoke((Object)action.getMessage(), this.muleContext);
        }
        Object result = 604 == action.getAction() ? this.invokeAction(action, context) : (603 == action.getAction() || 602 == action.getAction() ? this.sendAction(action, context) : (601 == action.getAction() ? this.receiveAction(action, context) : this.handleException(null, (Throwable)new DefaultMuleException(CoreMessages.eventTypeNotRecognised((String)("RemoteDispatcherNotification:" + action.getAction()))))));
        return result;
    }

    protected ServerHandshake doHandshake(MuleEventContext context) throws TransformerException {
        ServerHandshake handshake = new ServerHandshake();
        handshake.setWireFormatClass(this.wireFormat.getClass().getName());
        return handshake;
    }

    protected Object invokeAction(RemoteDispatcherNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        String endpoint = action.getResourceIdentifier();
        String destComponent = action.getResourceIdentifier().startsWith("mule:") ? endpoint.substring(endpoint.lastIndexOf("/") + 1) : endpoint;
        if (destComponent != null) {
            Object flowConstruct = this.muleContext.getRegistry().lookupObject(destComponent);
            if (!(flowConstruct instanceof FlowConstruct) || !(flowConstruct instanceof MessageProcessor)) {
                return this.handleException(null, (Throwable)new DefaultMuleException(ClientMessages.noSuchFlowConstruct(destComponent)));
            }
            EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder((ImmutableEndpoint)this.inboundEndpoint);
            builder.setTransformers(new LinkedList());
            InboundEndpoint ep = this.muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
            DefaultMuleEvent event = new DefaultMuleEvent(action.getMessage(), ep, context.getFlowConstruct(), context.getSession());
            event = RequestContext.setEvent((MuleEvent)event);
            if (context.getExchangePattern().hasResponse()) {
                MuleEvent resultEvent = ((MessageProcessor)flowConstruct).process((MuleEvent)event);
                MuleMessage muleMessage = result = resultEvent == null || VoidMuleEvent.getInstance().equals(resultEvent) ? null : resultEvent.getMessage();
                if (result == null) {
                    return null;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
                return out.toByteArray();
            }
            ((MessageProcessor)flowConstruct).process((MuleEvent)event);
            return null;
        }
        return this.handleException(result, (Throwable)new DefaultMuleException(CoreMessages.couldNotDetermineDestinationComponentFromEndpoint((String)endpoint)));
    }

    protected Object sendAction(RemoteDispatcherNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        OutboundEndpoint endpoint = null;
        MuleContext managementContext = context.getMuleContext();
        try {
            if (602 == action.getAction()) {
                endpoint = managementContext.getEndpointFactory().getOutboundEndpoint(action.getResourceIdentifier());
                context.dispatchEvent(action.getMessage(), endpoint);
                return null;
            }
            EndpointFactory endpointFactory = managementContext.getEndpointFactory();
            EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(action.getResourceIdentifier());
            endpointBuilder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
            endpoint = managementContext.getEndpointFactory().getOutboundEndpoint(endpointBuilder);
            result = context.sendEvent(action.getMessage(), endpoint);
            if (result == null || VoidMuleEvent.getInstance().equals(result)) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
            return out.toByteArray();
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    protected Object receiveAction(RemoteDispatcherNotification action, MuleEventContext context) throws MuleException {
        MuleMessage result = null;
        try {
            OutboundEndpoint endpoint = context.getMuleContext().getEndpointFactory().getOutboundEndpoint(action.getResourceIdentifier());
            long timeout = MapUtils.getLongValue((Map)action.getProperties(), (Object)"MULE_EVENT_TIMEOUT", (long)this.getSynchronousEventTimeout());
            result = endpoint.getConnector().request(action.getResourceIdentifier(), timeout);
            if (result != null) {
                List transformers = ((AbstractConnector)endpoint.getConnector()).getDefaultInboundTransformers((ImmutableEndpoint)endpoint);
                if (transformers != null) {
                    result.applyTransformers(null, transformers);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
                return out.toByteArray();
            }
            return null;
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    public static Service getSerivce(InboundEndpoint endpoint, WireFormat wireFormat, String encoding, int eventTimeout, MuleContext muleContext) throws MuleException {
        try {
            SedaService service = new SedaService(muleContext);
            service.setName(MANAGER_COMPONENT_NAME);
            service.setModel(muleContext.getRegistry().lookupSystemModel());
            RemoteDispatcherComponent rdc = new RemoteDispatcherComponent(endpoint, wireFormat, encoding, new Integer(eventTimeout));
            SimpleCallableJavaComponent component = new SimpleCallableJavaComponent((ObjectFactory)new SingletonObjectFactory((Object)rdc));
            component.setMuleContext(muleContext);
            service.setComponent((Component)component);
            if (!(service.getMessageSource() instanceof CompositeMessageSource)) {
                throw new IllegalStateException("Only 'CompositeMessageSource' is supported with RemoteDispatcherService");
            }
            ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)endpoint);
            return service;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, null);
        }
    }

    protected Object handleException(MuleMessage result, Throwable e) {
        logger.error((Object)("Failed to process admin request: " + e.getMessage()), e);
        if (result == null || VoidMuleEvent.getInstance().equals(result)) {
            result = new DefaultMuleMessage((Object)NullPayload.getInstance(), (Map)null, this.muleContext);
        }
        result.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload(e));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write((OutputStream)out, (Object)result, this.getEncoding());
            return out.toByteArray();
        }
        catch (Exception e1) {
            logger.error((Object)("Failed to format message, using direct string (details at debug level): " + e1.getMessage()));
            logger.debug((Object)e1.toString(), (Throwable)e1);
            return e.getMessage();
        }
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getSynchronousEventTimeout() {
        return this.synchronousEventTimeout;
    }

    public void setSynchronousEventTimeout(int synchronousEventTimeout) {
        this.synchronousEventTimeout = synchronousEventTimeout;
    }
}

