/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.client;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.notifications.AdminNotification;
import org.mule.impl.security.MuleCredentials;
import org.mule.providers.AbstractConnector;
import org.mule.providers.service.ConnectorFactory;
import org.mule.transformers.xml.ObjectToXml;
import org.mule.transformers.xml.XmlToObject;
import org.mule.umo.FutureMessageResult;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.security.UMOCredentials;
import org.mule.util.MuleObjectHelper;

public class RemoteDispatcher
implements Disposable {
    protected static transient Log logger = LogFactory.getLog((Class)RemoteDispatcher.class);
    private UMOEndpoint serverEndpoint;
    private UMOCredentials credentials = null;
    private ExecutorService executor;
    private ObjectToXml objectToXml;
    private XmlToObject xmlToObject;

    protected RemoteDispatcher(String endpoint, UMOCredentials credentials) throws UMOException {
        this(endpoint);
        this.credentials = credentials;
    }

    protected RemoteDispatcher(String endpoint) throws UMOException {
        this.serverEndpoint = new MuleEndpoint(endpoint, true);
        this.objectToXml = new ObjectToXml();
        this.xmlToObject = new XmlToObject();
    }

    protected void setExecutorService(ExecutorService e) {
        this.executor = e;
    }

    public void dispatchToRemoteComponent(String component, Object payload, Map messageProperties) throws UMOException {
        this.doToRemoteComponent(component, payload, messageProperties, true);
    }

    public UMOMessage sendToRemoteComponent(String component, Object payload, Map messageProperties) throws UMOException {
        return this.doToRemoteComponent(component, payload, messageProperties, true);
    }

    public FutureMessageResult sendAsyncToRemoteComponent(final String component, String transformers, final Object payload, final Map messageProperties) throws UMOException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemoteComponent(component, payload, messageProperties, true);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        if (this.executor != null) {
            result.setExecutor((Executor)this.executor);
        }
        if (transformers != null) {
            result.setTransformer(MuleObjectHelper.getTransformer((String)transformers, (String)","));
        }
        result.execute();
        return result;
    }

    public UMOMessage sendRemote(String endpoint, Object payload, Map messageProperties, int timeout) throws UMOException {
        return this.doToRemote(endpoint, payload, messageProperties, true, timeout);
    }

    public UMOMessage sendRemote(String endpoint, Object payload, Map messageProperties) throws UMOException {
        return this.doToRemote(endpoint, payload, messageProperties, true, MuleManager.getConfiguration().getSynchronousEventTimeout());
    }

    public void dispatchRemote(String endpoint, Object payload, Map messageProperties) throws UMOException {
        this.doToRemote(endpoint, payload, messageProperties, false, -1);
    }

    public FutureMessageResult sendAsyncRemote(final String endpoint, final Object payload, final Map messageProperties) throws UMOException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemote(endpoint, payload, messageProperties, true, -1);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        if (this.executor != null) {
            result.setExecutor((Executor)this.executor);
        }
        result.execute();
        return result;
    }

    public UMOMessage receiveRemote(String endpoint, int timeout) throws UMOException {
        AdminNotification action = new AdminNotification(null, 601, endpoint);
        action.setProperty((Object)"MULE_REMOTE_SYNC", (Object)"true");
        action.setProperty((Object)"MULE_EVENT_TIMEOUT", (Object)new Long(timeout));
        UMOMessage result = this.dispatchAction(action, true, timeout);
        return result;
    }

    public FutureMessageResult asyncReceiveRemote(final String endpoint, final int timeout) throws UMOException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.receiveRemote(endpoint, timeout);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable);
        if (this.executor != null) {
            result.setExecutor((Executor)this.executor);
        }
        result.execute();
        return result;
    }

    protected UMOMessage doToRemoteComponent(String component, Object payload, Map messageProperties, boolean synchronous) throws UMOException {
        MuleMessage message = new MuleMessage(payload, messageProperties);
        message.setBooleanProperty("MULE_REMOTE_SYNC", synchronous);
        this.setCredentials((UMOMessage)message);
        AdminNotification action = new AdminNotification((UMOMessage)message, 604, "mule://" + component);
        UMOMessage result = this.dispatchAction(action, synchronous, MuleManager.getConfiguration().getSynchronousEventTimeout());
        return result;
    }

    protected UMOMessage doToRemote(String endpoint, Object payload, Map messageProperties, boolean synchronous, int timeout) throws UMOException {
        MuleMessage message = new MuleMessage(payload, messageProperties);
        message.setProperty("MULE_REMOTE_SYNC", (Object)String.valueOf(synchronous));
        this.setCredentials((UMOMessage)message);
        AdminNotification action = new AdminNotification((UMOMessage)message, synchronous ? 603 : 602, endpoint);
        UMOMessage result = this.dispatchAction(action, synchronous, timeout);
        return result;
    }

    protected UMOMessage dispatchAction(AdminNotification action, boolean synchronous, int timeout) throws UMOException {
        UMOMessage result;
        block6: {
            UMOEndpoint endpoint = ConnectorFactory.createEndpoint((UMOEndpointURI)this.serverEndpoint.getEndpointURI(), (String)"sender");
            endpoint.setRemoteSync(synchronous);
            String xml = (String)this.objectToXml.transform((Object)action);
            UMOMessage message = action.getMessage();
            message = message == null ? new MuleMessage((Object)xml) : new MuleMessage((Object)xml, (UMOMessageAdapter)message);
            message.addProperties(action.getProperties());
            MuleSession session = new MuleSession(message, ((AbstractConnector)endpoint.getConnector()).getSessionHandler());
            MuleEvent event = new MuleEvent(message, (UMOImmutableEndpoint)endpoint, (UMOSession)session, true);
            event.setTimeout(timeout);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MuleClient sending remote call to: " + action.getResourceIdentifier() + ". At " + this.serverEndpoint.toString() + " .Event is: " + event));
            }
            UMOMessageDispatcher dispatcher = endpoint.getConnector().getDispatcher((UMOImmutableEndpoint)this.serverEndpoint);
            result = null;
            try {
                if (!synchronous) {
                    dispatcher.dispatch((UMOEvent)event);
                    return null;
                }
                result = dispatcher.send((UMOEvent)event);
                if (result == null) break block6;
                String resultXml = result.getPayloadAsString();
                if (resultXml != null && resultXml.length() > 0) {
                    Object obj = this.xmlToObject.transform((Object)resultXml);
                    result = obj instanceof AdminNotification ? ((AdminNotification)obj).getMessage() : (UMOMessage)obj;
                    break block6;
                }
                return result;
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of MuleClient remote call is: " + (result == null ? "null" : result.getPayload())));
        }
        return result;
    }

    public void dispose() {
    }

    protected void setCredentials(UMOMessage message) {
        if (this.credentials != null) {
            message.setProperty("MULE_USER", (Object)MuleCredentials.createHeader((String)this.credentials.getUsername(), (char[])this.credentials.getPassword()));
        }
    }
}

