/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.builders.AutoConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringUtils;

public abstract class AbstractResourceConfigurationBuilder
extends AbstractConfigurationBuilder {
    protected static final Log logger = LogFactory.getLog(AutoConfigurationBuilder.class);
    protected ConfigResource[] configResources;

    public AbstractResourceConfigurationBuilder(String configResources) throws ConfigurationException {
        this.configResources = this.loadConfigResources(StringUtils.splitAndTrim((String)configResources, (String)",; "));
    }

    public AbstractResourceConfigurationBuilder(String[] configResources) throws ConfigurationException {
        this.configResources = this.loadConfigResources(configResources);
    }

    public AbstractResourceConfigurationBuilder(ConfigResource[] configResources) {
        this.configResources = configResources;
    }

    public void configure(MuleContext muleContext) throws ConfigurationException {
        if (this.configResources == null) {
            throw new ConfigurationException(CoreMessages.objectIsNull((String)"Configuration Resources"));
        }
        super.configure(muleContext);
        logger.info((Object)CoreMessages.configurationBuilderSuccess((ConfigurationBuilder)this, (String)this.createConfigResourcesString()));
    }

    protected ConfigResource[] loadConfigResources(String[] configs) throws ConfigurationException {
        try {
            this.configResources = new ConfigResource[configs.length];
            for (int i = 0; i < configs.length; ++i) {
                this.configResources[i] = new ConfigResource(configs[i]);
            }
            return this.configResources;
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected String createConfigResourcesString() {
        StringBuffer configResourcesString = new StringBuffer();
        configResourcesString.append("[");
        for (int i = 0; i < this.configResources.length; ++i) {
            configResourcesString.append(this.configResources[i]);
            if (i >= this.configResources.length - 1) continue;
            configResourcesString.append(", ");
        }
        configResourcesString.append("]");
        return configResourcesString.toString();
    }
}

