/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.bpm;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.bpm.MessageService;
import org.mule.module.bpm.RulesEngine;

public class Rules
implements Initialisable,
Disposable,
MessageService {
    private final RulesEngine rulesEngine;
    private final String resource;
    private final Object configuration;
    private String entryPoint;
    private Collection initialFacts;
    private boolean stateless;
    private boolean cepMode;
    private transient Object sessionData;
    protected transient MuleContext muleContext;
    private transient FlowConstruct flowConstruct;
    protected static final Log logger = LogFactory.getLog(Rules.class);

    public Rules(RulesEngine rulesEngine, String resource, Object configuration, String entryPoint, Collection initialFacts, boolean stateless, boolean cepMode, FlowConstruct flowConstruct, MuleContext muleContext) {
        this.rulesEngine = rulesEngine;
        this.resource = resource;
        this.configuration = configuration;
        this.entryPoint = entryPoint;
        this.initialFacts = initialFacts;
        this.stateless = stateless;
        this.cepMode = cepMode;
        this.flowConstruct = flowConstruct;
        this.muleContext = muleContext;
    }

    public void initialise() throws InitialisationException {
        try {
            this.sessionData = this.rulesEngine.createSession(this);
            for (Object obj : this.initialFacts) {
                logger.debug((Object)("Adding initial data to the knowledge base: " + obj));
                this.rulesEngine.assertFact(this, obj);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void dispose() {
        if (this.sessionData != null) {
            try {
                this.rulesEngine.disposeSession(this.sessionData);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            finally {
                this.sessionData = null;
            }
        }
    }

    protected Object handleEvent(MuleEvent event) throws Exception {
        Object payload = event.getMessage().getPayload();
        logger.debug((Object)("Adding message payload to the knowledge base: " + payload));
        if (this.cepMode) {
            return this.rulesEngine.assertEvent(this, payload, this.entryPoint);
        }
        return this.rulesEngine.assertFact(this, payload);
    }

    @Override
    public MuleMessage generateMessage(String endpoint, Object payload, Map messageProperties, MessageExchangePattern exchangePattern) throws MuleException {
        Object message = payload instanceof MuleMessage ? (MuleMessage)payload : new DefaultMuleMessage(payload, this.muleContext);
        message.addProperties(messageProperties, PropertyScope.INBOUND);
        message.addProperties(messageProperties, PropertyScope.INVOCATION);
        EndpointBuilder endpointBuilder = this.muleContext.getEndpointFactory().getEndpointBuilder(endpoint);
        endpointBuilder.setExchangePattern(exchangePattern);
        OutboundEndpoint ep = endpointBuilder.buildOutboundEndpoint();
        DefaultMuleEvent event = new DefaultMuleEvent(message, ep.getExchangePattern(), this.flowConstruct);
        RequestContext.setEvent((MuleEvent)event);
        MuleEvent resultEvent = ep.process((MuleEvent)event);
        MuleMessage response = null;
        if (resultEvent != null && !VoidMuleEvent.getInstance().equals(resultEvent) && (response = resultEvent.getMessage()).getExceptionPayload() != null) {
            throw new DispatchException(MessageFactory.createStaticMessage((String)"Unable to send or route message"), (MuleEvent)event, (MessageProcessor)ep, response.getExceptionPayload().getRootException());
        }
        return response;
    }

    public String getResource() {
        return this.resource;
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public String getEntryPointLabel() {
        return this.entryPoint;
    }

    public Object getSessionData() {
        return this.sessionData;
    }

    public Collection getInitialVariables() {
        return this.initialFacts;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public boolean isCepMode() {
        return this.cepMode;
    }
}

