/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mule.module.boot.MuleBootstrapUtils;
import org.mule.util.FileUtils;

public final class JarUtils {
    private JarUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap readJarFileEntries(File jarFile) throws Exception {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        JarFile jarFileWrapper = null;
        if (jarFile != null) {
            try {
                jarFileWrapper = new JarFile(jarFile);
                Enumeration<JarEntry> iter = jarFileWrapper.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    InputStream entryStream = jarFileWrapper.getInputStream(zipEntry);
                    try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                        MuleBootstrapUtils.copy(entryStream, byteArrayStream);
                        entries.put(zipEntry.getName(), byteArrayStream.toByteArray());
                    }
                }
            }
            finally {
                if (jarFileWrapper != null) {
                    jarFileWrapper.close();
                }
            }
        }
        return entries;
    }

    public static void appendJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        if (entries != null) {
            LinkedHashMap combinedEntries = JarUtils.readJarFileEntries(jarFile);
            combinedEntries.putAll(entries);
            File tmpJarFile = File.createTempFile(jarFile.getName(), null);
            JarUtils.createJarFileEntries(tmpJarFile, combinedEntries);
            jarFile.delete();
            FileUtils.renameFile((File)tmpJarFile, (File)jarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        ZipOutputStream jarStream = null;
        FileOutputStream fileStream = null;
        if (jarFile != null) {
            try {
                fileStream = new FileOutputStream(jarFile);
                jarStream = new JarOutputStream(fileStream);
                if (entries != null && !entries.isEmpty()) {
                    for (String jarFilePath : entries.keySet()) {
                        Object content = entries.get(jarFilePath);
                        JarEntry entry = new JarEntry(jarFilePath);
                        ((JarOutputStream)jarStream).putNextEntry(entry);
                        if (content instanceof String) {
                            JarUtils.writeJarEntry((OutputStream)jarStream, ((String)content).getBytes());
                            continue;
                        }
                        if (content instanceof byte[]) {
                            JarUtils.writeJarEntry((OutputStream)jarStream, (byte[])content);
                            continue;
                        }
                        if (!(content instanceof File)) continue;
                        JarUtils.writeJarEntry((OutputStream)jarStream, (File)content);
                    }
                }
                jarStream.flush();
                fileStream.getFD().sync();
            }
            finally {
                if (jarStream != null) {
                    jarStream.close();
                }
                if (fileStream != null) {
                    fileStream.close();
                }
            }
        }
    }

    private static void writeJarEntry(OutputStream stream, byte[] entry) throws IOException {
        stream.write(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeJarEntry(OutputStream stream, File entry) throws IOException {
        try (FileInputStream fileContentStream = null;){
            fileContentStream = new FileInputStream(entry);
            MuleBootstrapUtils.copy(fileContentStream, stream);
        }
    }
}

