/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.modules.boot.MuleBootstrapUtils;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.JarUtils;

public final class LicenseHandler {
    private static final Log logger = LogFactory.getLog((Class)LicenseHandler.class);
    private static final int MAX_ROWS_TO_DISPLAY = 80;
    private static final String DEFAULT_LICENSE_TYPE = "Common Public Attribution License Version 1.0 (CPAL)";
    private static final String DEFAULT_LICENSE_VERSION = "UNKNOWN";
    private static final String VERSION_TEXT_PREFIX = "Version ";
    private static final String LICENSE_TEXT_FILENAME = "LICENSE.txt";
    private static final String LICENSE_TEXT_JAR_FILE_PATH = "META-INF/mule/LICENSE.txt";
    private static final String LICENSE_PROPERTIES_JAR_FILE_PATH = "META-INF/mule/license.props";

    private LicenseHandler() {
    }

    public static boolean isLicenseAccepted() throws Exception {
        return ClassUtils.getResource((String)LICENSE_PROPERTIES_JAR_FILE_PATH, (Class)LicenseHandler.class) != null;
    }

    public static File getLicenseFile() {
        return new File(MuleBootstrapUtils.getMuleHomeFile(), LICENSE_TEXT_FILENAME);
    }

    public static boolean getAcceptance() {
        boolean hasAccepted = false;
        try {
            if (!LicenseHandler.getLicenseFile().exists() || !MuleBootstrapUtils.getMuleLibDir().exists()) {
                System.out.println("\nYour Mule installation seems to be incomplete. Please try downloading it again from http://mule.mulesource.org/display/MULE/Download and start again.");
                hasAccepted = false;
            } else {
                System.out.println("\n\nPlease read over the following license agreement carefully:\n\n");
                LicenseInfo licenseInfo = LicenseHandler.readLicenseFileAndDisplayToStdout();
                hasAccepted = LicenseHandler.askUserForAcceptance();
                if (hasAccepted) {
                    LicenseHandler.saveLicenseInfo(licenseInfo);
                }
            }
        }
        catch (Exception e) {
            hasAccepted = false;
            System.out.println("\nSorry, we encountered an error in processing your license agreement - please try again.");
            e.printStackTrace();
        }
        return hasAccepted;
    }

    public static void saveLicenseInfo(LicenseInfo licenseInfo) throws Exception {
        if (licenseInfo != null && !LicenseHandler.isLicenseAccepted()) {
            if (!MuleBootstrapUtils.getMuleLibDir().canWrite()) {
                throw new Exception("No write permissions for mule-local-install.jar to MULE_HOME. If you are using MULE_BASE and multiple deployments, please ask your administrator to run Mule for the first time.");
            }
            File tempJarFile = LicenseHandler.createTempLicenseJarFile(licenseInfo);
            MuleBootstrapUtils.getMuleLocalJarFile().delete();
            FileUtils.renameFile((File)tempJarFile, (File)MuleBootstrapUtils.getMuleLocalJarFile());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LicenseInfo readLicenseFileAndDisplayToStdout() throws IOException {
        String licenseType = null;
        String licenseVersion = null;
        BufferedReader stdin = null;
        BufferedReader fileReader = null;
        stdin = new BufferedReader(new InputStreamReader(System.in));
        fileReader = new BufferedReader(new FileReader(LicenseHandler.getLicenseFile()));
        int row = 1;
        while (fileReader.ready()) {
            String line = fileReader.readLine();
            if (row == 1 && line.length() > 0) {
                licenseType = line;
            }
            if (row == 2 && line.startsWith(VERSION_TEXT_PREFIX)) {
                licenseVersion = line.substring(VERSION_TEXT_PREFIX.length());
            }
            if (row % 80 == 0) {
                System.out.print("\nHit return to continue ... ");
                stdin.readLine();
            }
            System.out.println(line);
            ++row;
        }
        Object var7_7 = null;
        if (fileReader == null) return new LicenseInfo(licenseType, licenseVersion);
        try {
            fileReader.close();
            return new LicenseInfo(licenseType, licenseVersion);
        }
        catch (Exception ignore) {
            logger.debug((Object)("Error closing fileReader: " + ignore.getMessage()));
        }
        return new LicenseInfo(licenseType, licenseVersion);
        {
            catch (IOException ioe) {
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fileReader == null) throw throwable;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (Exception ignore) {
                logger.debug((Object)("Error closing fileReader: " + ignore.getMessage()));
            }
            throw throwable;
        }
    }

    private static boolean askUserForAcceptance() throws IOException {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("\n\nDo you accept the terms and conditions of this license agreement [y/n]?");
        boolean hasAcccepted = stdin.readLine().toLowerCase().startsWith("y");
        if (!hasAcccepted) {
            System.out.println("\nSorry, until you accept the terms and conditions of this EULA, you won't be able to start Mule");
        }
        return hasAcccepted;
    }

    private static File createTempLicenseJarFile(LicenseInfo licenseInfo) throws Exception {
        LinkedHashMap<String, Object> jarEntries = new LinkedHashMap<String, Object>();
        jarEntries.put(LICENSE_PROPERTIES_JAR_FILE_PATH, licenseInfo.toString());
        jarEntries.put(LICENSE_TEXT_JAR_FILE_PATH, LicenseHandler.getLicenseFile());
        File tempJar = File.createTempFile("mule-local-install.jar", null);
        try {
            JarUtils.createJarFileEntries((File)tempJar, jarEntries);
        }
        catch (IOException ioe) {
            if (tempJar != null) {
                throw new Exception("Unable to create temporary jar file to " + tempJar.getAbsolutePath());
            }
            throw new Exception("Unable to create temporary jar file for mule-local-install.jar");
        }
        return tempJar;
    }

    public static class LicenseInfo {
        private String licenseType = "Common Public Attribution License Version 1.0 (CPAL)";
        private String licenseVersion = "UNKNOWN";
        private String licenseDate = new Date().toString();

        public LicenseInfo() {
        }

        public LicenseInfo(String licenseType, String licenseVersion) {
            if (StringUtils.isNotBlank((String)licenseType)) {
                this.licenseType = licenseType;
            }
            if (StringUtils.isNotBlank((String)licenseVersion)) {
                this.licenseVersion = licenseVersion;
            }
        }

        public String toString() {
            return "LicenseType=" + this.licenseType + "\n" + "LicenseVersion=" + this.licenseVersion + "\n" + "LicenseDate=" + this.licenseDate + "\n";
        }
    }
}

