/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.mule.modules.boot.DefaultMuleClassPathConfig;
import org.mule.modules.boot.LibraryDownloader;

public final class MuleBootstrapUtils {
    private static final String MULE_LIB_FILENAME = "lib" + File.separator + "mule";
    private static final String MULE_HOME = System.getProperty("mule.home");
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";

    private MuleBootstrapUtils() {
    }

    public static File getMuleHomeFile() {
        return new File(MULE_HOME);
    }

    public static File getMuleLibDir() {
        return new File(MULE_HOME + File.separator + MULE_LIB_FILENAME);
    }

    public static File getMuleLocalJarFile() {
        return new File(MuleBootstrapUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME);
    }

    public static void addLocalJarFilesToClasspath(File muleHome, File muleBase) throws Exception {
        DefaultMuleClassPathConfig classPath = new DefaultMuleClassPathConfig(muleHome, muleBase);
        MuleBootstrapUtils.addLibrariesToClasspath(classPath.getURLs());
    }

    public static void addExternalJarFilesToClasspath(File muleHome, ProxyInfo proxyInfo) throws Exception {
        LibraryDownloader downloader = null;
        downloader = proxyInfo != null ? new LibraryDownloader(muleHome, proxyInfo.host, proxyInfo.port, proxyInfo.username, proxyInfo.password) : new LibraryDownloader(muleHome);
        MuleBootstrapUtils.addLibrariesToClasspath(downloader.downloadLibraries());
    }

    public static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    public static class ProxyInfo {
        String host;
        String port;
        String username;
        String password;

        public ProxyInfo(String host, String port) {
            this(host, port, null, null);
        }

        public ProxyInfo(String host, String port, String username, String password) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }
    }
}

