/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class LicenseHandler {
    private File muleHome;
    private File muleBase;
    private static int maxRowsToDisplay = 80;
    public static String defaultLicenseType = "MuleSource Public License";
    public static String defaultLicenseVersion = "UNKNOWN";
    public static String ackJarName = "mule-local-install.jar";
    public static String ackLicenseName = "META-INF/mule/LICENSE.txt";
    public static String ackFileName = "META-INF/mule/license.props";
    public static String licenseFileName = "LICENSE.txt";

    public LicenseHandler(File muleHome) {
        this.muleHome = muleHome;
        this.muleBase = muleHome;
    }

    public LicenseHandler(File muleHome, File muleBase) {
        this.muleHome = muleHome;
        this.muleBase = muleBase;
    }

    public boolean getAcceptance() {
        String licenseType = "";
        String licenseVersion = "";
        try {
            File licenseFile = new File(this.muleHome, licenseFileName);
            File muleLib = new File(this.muleHome, "lib/mule");
            if (!licenseFile.exists() || !muleLib.exists()) {
                System.out.println("\nYour Mule installation seems to be incomplete. Please try downloading it again from http://mule.mulesource.org/display/MULE/Download and start again.");
                return false;
            }
            System.out.println("\n\nPlease read over the following license agreement carefully:\n\n");
            int row = 1;
            String input = "";
            BufferedReader is = new BufferedReader(new InputStreamReader(System.in));
            BufferedReader br = new BufferedReader(new FileReader(licenseFile));
            while (br.ready()) {
                String line = br.readLine();
                if (row == 1) {
                    licenseType = line;
                }
                if (row == 2 && line.startsWith("Version ")) {
                    licenseVersion = line.substring(8);
                }
                if (row % maxRowsToDisplay == 0) {
                    System.out.print("\nHit return to continue ... ");
                    input = is.readLine();
                }
                System.out.println(line);
                ++row;
            }
            System.out.print("\n\nDo you accept the terms and conditions of this license agreement [y/n]?");
            input = is.readLine();
            if (!input.toLowerCase().startsWith("y")) {
                System.out.println("\nSorry, until you accept the terms and conditions of this EULA, you won't be able to start Mule");
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("\nSorry, we encountered an error in processing your license agreement - please try again");
            return false;
        }
        if (licenseType.equals("")) {
            licenseType = defaultLicenseType;
        }
        if (licenseVersion.equals("")) {
            licenseVersion = defaultLicenseVersion;
        }
        try {
            this.saveLicenseAck(licenseType, licenseVersion);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public void saveLicenseAck(String licenseType, String licenseVersion) throws Exception {
        File newJarFile;
        block28: {
            File muleLib = new File(this.muleHome, "lib/mule");
            File tempJar = this.createAckJarFile(licenseType, licenseVersion);
            if (this.licenseJarExists()) {
                return;
            }
            if (!muleLib.canWrite()) {
                if (!this.muleHome.getCanonicalFile().equals(this.muleBase.getCanonicalFile())) {
                    muleLib = new File(this.muleBase, "lib/user");
                    if (!muleLib.canWrite()) {
                        throw new Exception("No write permissions for " + ackJarName + " in either MULE_HOME or MULE_BASE");
                    }
                } else {
                    throw new Exception("No write permission for " + ackJarName);
                }
            }
            if ((newJarFile = new File(muleLib, ackJarName)).exists()) {
                throw new Exception("Unable to rename temporary jar to " + newJarFile.getAbsolutePath() + " a file with this name already exists!");
            }
            if (!tempJar.renameTo(newJarFile)) {
                if (!tempJar.exists()) {
                    return;
                }
                FileChannel srcChannel = null;
                AbstractInterruptibleChannel destChannel = null;
                srcChannel = new FileInputStream(tempJar.getAbsolutePath()).getChannel();
                destChannel = new FileOutputStream(newJarFile).getChannel();
                ((FileChannel)destChannel).transferFrom(srcChannel, 0L, srcChannel.size());
                Object var10_8 = null;
                try {
                    if (srcChannel != null) {
                        srcChannel.close();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                try {
                    if (destChannel != null) {
                        destChannel.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    tempJar.delete();
                }
                catch (Exception e3) {}
                break block28;
                {
                    catch (Exception e) {
                        throw new Exception("Unable to rename temporary jar to " + newJarFile.getAbsolutePath(), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    try {
                        if (srcChannel != null) {
                            srcChannel.close();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    try {
                        if (destChannel != null) {
                            destChannel.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        tempJar.delete();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (!newJarFile.exists()) {
            throw new Exception("Unable to rename temporary jar to " + newJarFile.getAbsolutePath());
        }
    }

    public boolean licenseJarExists() {
        try {
            ZipEntry entry;
            File muleLib = new File(this.muleHome, "lib/mule");
            File testJarFile = new File(muleLib, ackJarName);
            JarFile jar = null;
            if (testJarFile.exists()) {
                jar = new JarFile(testJarFile);
            } else if (!this.muleHome.getCanonicalFile().equals(this.muleBase.getCanonicalFile()) && (testJarFile = new File(muleLib = new File(this.muleBase, "lib/user"), ackJarName)).exists()) {
                jar = new JarFile(testJarFile);
            }
            if (jar != null && (entry = jar.getEntry(ackFileName)) != null) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("Unknown error checking for license jar: " + e.toString());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createAckJarFile(String licenseType, String licenseVersion) throws Exception {
        JarOutputStream newJar;
        File tempJar;
        block12: {
            FileOutputStream fos;
            tempJar = File.createTempFile(ackJarName, null);
            File licenseFile = new File(this.muleHome, licenseFileName);
            String ackData = "LicenseType=" + licenseType + "\n";
            ackData = ackData + "LicenseVersion=" + licenseVersion + "\n";
            ackData = ackData + "LicenseDate=" + new Date().toString() + "\n";
            try {
                fos = new FileOutputStream(tempJar);
                newJar = new JarOutputStream(fos);
            }
            catch (IOException ioe) {
                throw new Exception("Unable to create temporary jar file");
            }
            byte[] buffer = new byte[1024];
            FileInputStream fis = null;
            try {
                try {
                    int bytesRead;
                    fis = new FileInputStream(licenseFile);
                    JarEntry entry = new JarEntry(ackFileName);
                    newJar.putNextEntry(entry);
                    newJar.write(ackData.getBytes(), 0, ackData.getBytes().length);
                    entry = new JarEntry(ackLicenseName);
                    newJar.putNextEntry(entry);
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        newJar.write(buffer, 0, bytesRead);
                    }
                    newJar.flush();
                    fos.getFD().sync();
                }
                catch (IOException ioe) {
                    throw new Exception("Unable to write " + ackFileName + " to temporary jar file");
                }
                Object var13_15 = null;
                if (fis == null) break block12;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            fis.close();
        }
        try {
            newJar.close();
            return tempJar;
        }
        catch (IOException ioe) {
            throw new Exception("Unable to close temporary jar file");
        }
    }
}

