/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.boot;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DefaultMuleClassPathConfig {
    protected static final String FOLDER_MULE = "/lib/mule";
    protected static final String FOLDER_OPT = "/lib/opt";
    protected static final String FOLDER_USER = "/lib/user";
    private List urls = new LinkedList();

    public DefaultMuleClassPathConfig(File muleHome, File muleBase) {
        try {
            File jar;
            int i;
            File[] muleJars;
            this.addURL(new URL("file://" + muleHome.getAbsolutePath() + FOLDER_USER + "/"));
            this.addURL(new URL("file://" + muleHome.getAbsolutePath() + FOLDER_MULE + "/"));
            this.addURL(new URL("file://" + muleHome.getAbsolutePath() + FOLDER_OPT + "/"));
            try {
                if (!muleHome.getCanonicalFile().equals(muleBase.getCanonicalFile())) {
                    this.addURL(new URL("file://" + muleBase.getAbsolutePath() + FOLDER_USER + "/"));
                    muleJars = this.listJars(muleBase, FOLDER_USER);
                    for (i = 0; i < muleJars.length; ++i) {
                        jar = muleJars[i];
                        this.addURL(jar.toURL());
                    }
                }
            }
            catch (IOException ioe) {
                System.out.println("Unable to check to see if there are local jars to load: " + ioe.toString());
            }
            muleJars = this.listJars(muleHome, FOLDER_USER);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
            muleJars = this.listJars(muleHome, FOLDER_MULE);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
            muleJars = this.listJars(muleHome, FOLDER_OPT);
            for (i = 0; i < muleJars.length; ++i) {
                jar = muleJars[i];
                this.addURL(jar.toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to construct a classpath URL", e);
        }
    }

    public List getURLs() {
        return new ArrayList(this.urls);
    }

    public void addURLs(List urls) {
        if (urls != null && !urls.isEmpty()) {
            this.urls.addAll(urls);
        }
    }

    public void addURL(URL url) {
        this.urls.add(url);
    }

    protected File[] listJars(File muleDir, String muleSubfolder) {
        File path = new File(muleDir, muleSubfolder);
        File[] jars = path.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                try {
                    return pathname.getCanonicalPath().endsWith(".jar");
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
        return jars == null ? new File[]{} : jars;
    }
}

