/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom.routing;

import java.util.Date;
import org.apache.abdera.model.Feed;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;

public class FeedLastUpdatedFilter
implements Filter {
    private final transient Log logger = LogFactory.getLog(FeedLastUpdatedFilter.class);
    private Date lastUpdate;
    private boolean acceptWithoutUpdateDate = true;

    public FeedLastUpdatedFilter() {
    }

    public FeedLastUpdatedFilter(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean accept(MuleMessage message) {
        Feed feed;
        try {
            feed = (Feed)message.getPayload(Feed.class);
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)e);
        }
        Date updated = feed.getUpdated();
        if (updated == null) {
            if (this.isAcceptWithoutUpdateDate()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Feed does not have a last updated or published date set, assuming the feed should be processed");
                }
                return true;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Feed does not have a last updated or published date set, not consuming the feed because 'acceptWithoutUpdateDate' is false");
            }
            return false;
        }
        if (this.lastUpdate != null && (this.lastUpdate.after(updated) || this.lastUpdate.equals(updated))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Feed update is not newer than the last update, not processing");
            }
            return false;
        }
        this.lastUpdate = updated;
        return true;
    }

    public boolean isAcceptWithoutUpdateDate() {
        return this.acceptWithoutUpdateDate;
    }

    public void setAcceptWithoutUpdateDate(boolean acceptWithoutUpdateDate) {
        this.acceptWithoutUpdateDate = acceptWithoutUpdateDate;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }
}

