/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.AbstractRouter;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.ConsoleHandler;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.raml.interfaces.model.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
extends AbstractRouter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConsoleHandler consoleHandler;

    public Configuration getConfig() {
        return (Configuration)this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    @Override
    protected void startConfiguration() throws StartException {
        if (this.config == null) {
            try {
                this.config = (AbstractConfiguration)this.muleContext.getRegistry().lookupObject(Configuration.class);
            }
            catch (RegistrationException e) {
                throw new StartException(MessageFactory.createStaticMessage((String)"APIKit configuration not Found"), (Startable)this);
            }
        }
        this.config.loadApiDefinition(this.flowConstruct);
        if (this.getConfig().isConsoleEnabled()) {
            this.consoleHandler = new ConsoleHandler(this.getConfig().getEndpointAddress(this.flowConstruct), this.getConfig().getConsolePath(), this.config);
            this.consoleHandler.updateRamlUri();
            this.getConfig().addConsoleUrl(this.consoleHandler.getConsoleUrl());
        }
    }

    @Override
    protected MuleEvent handleEvent(MuleEvent event, String path) throws MuleException {
        if (this.getConfig().isConsoleEnabled() && path.startsWith("/" + this.getConfig().getConsolePath())) {
            return this.consoleHandler.process(event);
        }
        return null;
    }

    @Override
    protected Flow getFlow(IResource resource, HttpRestRequest request, String version) throws UnsupportedMediaTypeException {
        String baseKey = request.getMethod() + ":" + resource.getResolvedUri(version);
        String contentType = request.getContentType();
        Map<String, Flow> rawRestFlowMap = ((Configuration)this.config).getRawRestFlowMap();
        Flow flow = rawRestFlowMap.get(baseKey + ":" + contentType);
        if (flow == null && (flow = rawRestFlowMap.get(baseKey)) == null && this.isFlowDeclaredWithDifferentMediaType(rawRestFlowMap, baseKey)) {
            throw new UnsupportedMediaTypeException();
        }
        return flow;
    }

    protected boolean isFlowDeclaredWithDifferentMediaType(Map<String, Flow> map, String baseKey) {
        for (String flowName : map.keySet()) {
            String[] split = flowName.split(":");
            String methodAndResoruce = split[0] + ":" + split[1];
            if (!methodAndResoruce.equals(baseKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MuleEvent doProcessRouterResponse(MuleEvent event, Integer successStatus) {
        if (event.getMessage().getOutboundProperty("http.status") == null) {
            event.getMessage().setOutboundProperty("http.status", (Object)successStatus);
        }
        return event;
    }
}

