/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.expression;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.expression.ExpressionAnnotationParser;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.AnnotationsParserFactory;
import org.mule.config.i18n.AnnotationsMessages;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.expression.transformers.ExpressionTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionAnnotationsHelper {
    protected static Log logger = LogFactory.getLog(ExpressionAnnotationsHelper.class);

    public static ExpressionTransformer getTransformerForMethodWithAnnotations(Method method, MuleContext context) throws TransformerException, InitialisationException {
        ExpressionTransformer trans = new ExpressionTransformer();
        trans.setMuleContext(context);
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] annotation = annotations[i];
            for (int j = 0; j < annotation.length; ++j) {
                Annotation ann = annotation[j];
                ExpressionArgument arg = ExpressionAnnotationsHelper.parseAnnotation(ann, method.getParameterTypes()[i], context);
                if (arg == null) continue;
                trans.addArgument(arg);
            }
        }
        trans.initialise();
        return trans;
    }

    static synchronized ExpressionArgument parseAnnotation(Annotation annotation, Class<?> paramType, MuleContext muleContext) {
        AnnotationsParserFactory factory;
        try {
            factory = (AnnotationsParserFactory)muleContext.getRegistry().lookupObject(AnnotationsParserFactory.class);
        }
        catch (RegistrationException e) {
            throw new IllegalArgumentException(AnnotationsMessages.noParserFoundForAnnotation(annotation).getMessage());
        }
        ExpressionAnnotationParser parser = factory.getExpressionParser(annotation);
        if (parser == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)AnnotationsMessages.noParserFoundForAnnotation(annotation).getMessage());
            }
            return null;
        }
        return parser.parse(annotation, paramType);
    }
}

