/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.transformer;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.transformer.DataType;
import org.mule.config.transformer.TransformerArgumentResolver;
import org.mule.transformer.types.CollectionDataType;
import org.mule.util.annotation.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedTransformerArgumentResolver
implements TransformerArgumentResolver,
Disposable {
    public static final String[] ignoredPackages = new String[]{"java.", "javax.", "org.w3c.", "org.mule.transport.", "org.mule.module."};
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private Set<Class> matchingClasses = new CopyOnWriteArraySet<Class>();
    private Set<Class> nonMatchingClasses = new CopyOnWriteArraySet<Class>();

    @Override
    public <T> T resolve(Class<T> type, DataType source, DataType result, MuleContext context) throws Exception {
        if (!this.getArgumentClass().isAssignableFrom(type) || this.isNonMatching(source, result)) {
            return null;
        }
        Class annotatedType = result instanceof CollectionDataType ? ((CollectionDataType)result).getItemType() : result.getType();
        boolean isAnnotated = this.matchingClasses.contains(annotatedType);
        if (!isAnnotated) {
            isAnnotated = this.findAnnotation(annotatedType);
        }
        if (!isAnnotated && !(isAnnotated = this.matchingClasses.contains(annotatedType = source.getType()))) {
            isAnnotated = AnnotationUtils.hasAnnotationWithPackage((String)this.getAnnotationsPackageName(), (Class)annotatedType);
        }
        Object argument = context.getRegistry().lookupObject(this.getArgumentClass());
        if (!isAnnotated) {
            this.nonMatchingClasses.add(source.getType());
            this.nonMatchingClasses.add(result.getType());
            return (T)argument;
        }
        this.matchingClasses.add(annotatedType);
        if (argument == null) {
            this.logger.info((Object)("No common Object of type '" + this.getArgumentClass() + "' configured, creating a local one for: " + source + ", " + result));
            argument = this.createArgument(annotatedType, context);
        }
        return (T)argument;
    }

    protected boolean findAnnotation(Class annotatedType) throws IOException {
        if (annotatedType.getPackage() == null) {
            return false;
        }
        for (String ignoredPackage : ignoredPackages) {
            if (!annotatedType.getPackage().getName().startsWith(ignoredPackage)) continue;
            return false;
        }
        return AnnotationUtils.hasAnnotationWithPackage((String)this.getAnnotationsPackageName(), (Class)annotatedType);
    }

    protected boolean isNonMatching(DataType source, DataType result) {
        return this.nonMatchingClasses.contains(result.getType()) && this.nonMatchingClasses.contains(source.getType());
    }

    public void dispose() {
        this.nonMatchingClasses.clear();
        this.matchingClasses.clear();
    }

    public Set<Class> getMatchingClasses() {
        return this.matchingClasses;
    }

    public Set<Class> getNonMatchingClasses() {
        return this.nonMatchingClasses;
    }

    protected abstract Class getArgumentClass();

    protected abstract Object createArgument(Class var1, MuleContext var2) throws Exception;

    protected abstract String getAnnotationsPackageName();
}

