/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.expression.PropertyConverter;
import org.mule.api.registry.Registry;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.Connector;
import org.mule.config.annotations.endpoints.ChannelType;
import org.mule.config.annotations.i18n.AnnotationsMessages;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.impl.endpoint.AnnotatedEndpointData;
import org.mule.impl.registry.ConfigurableTransportFactory;
import org.mule.impl.registry.RegistryMap;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.util.TemplateParser;

public class AnnotatedEndpointHelper {
    protected TemplateParser parser = TemplateParser.createAntStyleParser();
    protected RegistryMap regMap;
    protected MuleContext muleContext;
    protected TransportFactory transportFactory;

    public AnnotatedEndpointHelper(MuleContext muleContext) throws MuleException {
        this.muleContext = muleContext;
        this.transportFactory = new ConfigurableTransportFactory(muleContext);
        this.regMap = new RegistryMap((Registry)muleContext.getRegistry());
    }

    protected String parsePlaceholderValues(String key) {
        return this.parser.parse((Map)((Object)this.regMap), key);
    }

    protected EndpointBuilder getEndpointBuilder(AnnotatedEndpointData epData) throws MuleException {
        String uri = this.parsePlaceholderValues(epData.getAddress());
        EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(uri);
        endpointBuilder.setMuleContext(this.muleContext);
        return endpointBuilder;
    }

    public ImmutableEndpoint processEndpoint(AnnotatedEndpointData epData) throws MuleException {
        InboundEndpoint endpoint;
        AbstractConnector connector;
        this.preprocessEndpointData(epData);
        EndpointBuilder endpointBuilder = this.getEndpointBuilder(epData);
        if (epData.getProperties() != null && epData.getProperties().size() > 0) {
            endpointBuilder.setProperties(epData.getProperties());
        }
        if (epData.getTransformers() != null) {
            List transformers = (List)this.convertProperty(List.class, epData.getTransformers());
            endpointBuilder.setTransformers(transformers);
        }
        if (epData.getFilter() != null) {
            Filter filter = (Filter)this.convertProperty(Filter.class, epData.getFilter());
            endpointBuilder.setFilter(filter);
        }
        if (epData.getEncoding() != null) {
            endpointBuilder.setEncoding(this.parsePlaceholderValues(epData.getEncoding()));
        }
        if (epData.getConnectorName() != null) {
            connector = (AbstractConnector)this.muleContext.getRegistry().lookupConnector(this.parsePlaceholderValues(epData.getConnectorName()));
        } else if (epData.getConnector() != null) {
            connector = (AbstractConnector)epData.getConnector();
        } else {
            MuleEndpointURI uri = new MuleEndpointURI(this.parsePlaceholderValues(epData.getAddress()), this.muleContext);
            connector = (AbstractConnector)this.transportFactory.createConnector((EndpointURI)uri);
            if (this.muleContext.getRegistry().lookupConnector(connector.getName()) == null) {
                this.muleContext.getRegistry().registerConnector((Connector)connector);
            }
        }
        endpointBuilder.setConnector((Connector)connector);
        String threadsString = (String)epData.getProperties().get("threads");
        if (threadsString != null) {
            int threads = Integer.valueOf(threadsString);
            connector.setMaxDispatchersActive(threads);
            connector.setMaxRequestersActive(threads);
            connector.getReceiverThreadingProfile().setMaxThreadsActive(threads);
            connector.getReceiverThreadingProfile().setMaxThreadsIdle(threads);
        }
        if (epData.getName() != null) {
            endpointBuilder.setName(this.parsePlaceholderValues(epData.getName()));
        }
        endpointBuilder.setSynchronous(epData.isSynchronous());
        if (epData.getType() == ChannelType.Inbound) {
            endpoint = endpointBuilder.buildInboundEndpoint();
        } else if (epData.getType() == ChannelType.Outbound) {
            endpoint = endpointBuilder.buildOutboundEndpoint();
        } else {
            throw new IllegalArgumentException("Channel type not recognised: " + (Object)((Object)epData.getType()));
        }
        if (epData.getName() != null) {
            this.muleContext.getRegistry().registerEndpointBuilder(epData.getName(), endpointBuilder);
        }
        return endpoint;
    }

    protected void preprocessEndpointData(AnnotatedEndpointData data) {
    }

    public Object convertProperty(Class type, String property) {
        String prop = this.parsePlaceholderValues(property);
        Collection c = this.muleContext.getRegistry().lookupObjects(PropertyConverter.class);
        for (PropertyConverter converter : c) {
            if (!converter.getType().equals(type)) continue;
            return converter.convert(prop, this.muleContext);
        }
        throw new IllegalArgumentException(AnnotationsMessages.noPropertyConverterForType(type).getMessage());
    }
}

