/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.concept;

import java.lang.annotation.Annotation;
import org.mule.api.MuleException;
import org.mule.api.transport.Connector;
import org.mule.config.annotations.concept.VmInbound;
import org.mule.config.annotations.concept.VmOutbound;
import org.mule.impl.endpoint.AbstractEndpointAnnotationParser;
import org.mule.impl.endpoint.AnnotatedEndpointData;
import org.mule.transport.vm.VMConnector;

public class VMAnnotationParser
extends AbstractEndpointAnnotationParser {
    public static final String VM_CHANNEL = "_ibeansVmChannel";

    protected AnnotatedEndpointData createEndpointData(Annotation annotation) throws MuleException {
        if (annotation instanceof VmInbound) {
            VmInbound vm = (VmInbound)annotation;
            String uri = "vm://" + vm.path();
            AnnotatedEndpointData epData = new AnnotatedEndpointData(vm.mep());
            epData.setProperties(this.convertProperties(vm.properties()));
            epData.setAddress(uri);
            epData.setFilter(vm.filter());
            epData.setConnector((Connector)this.getConnector());
            epData.setName(vm.id());
            return epData;
        }
        VmOutbound vm = (VmOutbound)annotation;
        String uri = "vm://" + vm.path();
        AnnotatedEndpointData epData = new AnnotatedEndpointData(vm.mep());
        epData.setProperties(this.convertProperties(vm.properties()));
        epData.setAddress(uri);
        epData.setFilter(vm.filter());
        epData.setConnector((Connector)this.getConnector());
        epData.setName(vm.id());
        return epData;
    }

    protected String getIdentifier() {
        return "vm";
    }

    protected VMConnector getConnector() throws MuleException {
        VMConnector connector = (VMConnector)this.muleContext.getRegistry().lookupConnector(VM_CHANNEL);
        if (connector == null) {
            connector = new VMConnector();
            connector.setName(VM_CHANNEL);
            this.muleContext.getRegistry().registerConnector((Connector)connector);
        }
        return connector;
    }
}

