/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.api.AnnotationException;
import org.mule.api.EndpointAnnotationParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.RouterAnnotationParser;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.object.ObjectFactory;
import org.mule.api.registry.Registry;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.service.Service;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.PooledJavaComponent;
import org.mule.config.annotations.endpoints.Bind;
import org.mule.config.annotations.endpoints.Channel;
import org.mule.config.annotations.endpoints.ChannelType;
import org.mule.config.annotations.endpoints.Reply;
import org.mule.config.annotations.i18n.AnnotationsMessages;
import org.mule.config.annotations.routing.Router;
import org.mule.config.annotations.routing.RouterType;
import org.mule.impl.annotations.ServiceScope;
import org.mule.impl.endpoint.AnnotatedEndpointBuilder;
import org.mule.impl.endpoint.AnnotatedEndpointData;
import org.mule.impl.endpoint.MEP;
import org.mule.impl.registry.RegistryMap;
import org.mule.model.seda.SedaService;
import org.mule.object.PrototypeObjectFactory;
import org.mule.object.SingletonObjectFactory;
import org.mule.routing.binding.DefaultInterfaceBinding;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.util.BeanUtils;
import org.mule.util.StringUtils;
import org.mule.util.TemplateParser;
import org.mule.utils.AnnotationMetaData;
import org.mule.utils.AnnotationUtils;

public class AnnotatedServiceBuilder {
    protected MuleContext context;
    private Model model;
    private final TemplateParser parser = TemplateParser.createAntStyleParser();
    protected RegistryMap regProps;
    protected AnnotatedEndpointBuilder builder;

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public AnnotatedServiceBuilder(MuleContext context) throws MuleException {
        this.context = context;
        this.regProps = new RegistryMap((Registry)context.getRegistry());
        this.builder = new AnnotatedEndpointBuilder(context);
    }

    protected ObjectFactory createObjectFactory(Object object) {
        org.mule.config.annotations.Service serv = object.getClass().getAnnotation(org.mule.config.annotations.Service.class);
        if (serv.scope().equals((Object)ServiceScope.SINGLETON)) {
            return new SingletonObjectFactory(object);
        }
        Map props = BeanUtils.describe((Object)object);
        return new PrototypeObjectFactory(object.getClass(), props);
    }

    public Service createService(Object object) throws MuleException {
        Class<?> componentFactoryClass = object.getClass();
        Service serviceDescriptor = this.create(this.createObjectFactory(object));
        this.processInbound(componentFactoryClass, serviceDescriptor);
        this.processOutbound(componentFactoryClass, serviceDescriptor);
        this.processEndpointBindings(componentFactoryClass, serviceDescriptor);
        this.processReply(componentFactoryClass, serviceDescriptor);
        return serviceDescriptor;
    }

    protected Service create(ObjectFactory componentFactory) throws InitialisationException {
        SedaService serviceDescriptor = new SedaService();
        org.mule.config.annotations.Service service = componentFactory.getObjectClass().getAnnotation(org.mule.config.annotations.Service.class);
        serviceDescriptor.setName(this.getValue(service.name()));
        componentFactory.initialise();
        if (service.scope().equals((Object)ServiceScope.POOLED)) {
            serviceDescriptor.setComponent((Component)new PooledJavaComponent(componentFactory));
        } else {
            serviceDescriptor.setComponent((Component)new DefaultJavaComponent(componentFactory));
        }
        return serviceDescriptor;
    }

    protected String getValue(String key) {
        return this.parser.parse((Map)this.regProps, key);
    }

    protected void processInbound(Class componentFactoryClass, Service service) throws MuleException {
        List<AnnotationMetaData> annotations = AnnotationUtils.getClassAndMethodAnnotations(componentFactoryClass);
        for (AnnotationMetaData annotation : annotations) {
            InboundEndpoint inboundEndpoint = this.tryInboundEndpointAnnotation(annotation, ChannelType.Inbound);
            if (inboundEndpoint == null) continue;
            if (annotation.getType() == ElementType.METHOD) {
                inboundEndpoint.getProperties().put("method", annotation.getElementName());
            }
            service.getInboundRouter().addEndpoint(inboundEndpoint);
        }
        this.processInboundRouters(componentFactoryClass, service);
    }

    protected void processInboundRouters(Class componentFactoryClass, Service service) throws MuleException {
        Collection routerParsers = this.context.getRegistry().lookupObjects(RouterAnnotationParser.class);
        block0: for (int i = 0; i < componentFactoryClass.getAnnotations().length; ++i) {
            Annotation annotation = componentFactoryClass.getAnnotations()[i];
            Router routerAnnotation = annotation.annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.Inbound) continue;
            for (RouterAnnotationParser parser : routerParsers) {
                if (!parser.supports(annotation, componentFactoryClass, null)) continue;
                service.getInboundRouter().addRouter(parser.parseRouter(annotation));
                continue block0;
            }
        }
    }

    protected void processReplyRouters(Class componentFactoryClass, Service service) throws MuleException {
        Collection routerParsers = this.context.getRegistry().lookupObjects(RouterAnnotationParser.class);
        List<AnnotationMetaData> annotations = AnnotationUtils.getClassAndMethodAnnotations(componentFactoryClass);
        block0: for (AnnotationMetaData metaData : annotations) {
            Router routerAnnotation = metaData.getAnnotation().annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.ReplyTo) continue;
            for (RouterAnnotationParser parser : routerParsers) {
                if (!parser.supports(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember())) continue;
                org.mule.api.routing.Router router = parser.parseRouter(metaData.getAnnotation());
                if (router instanceof MuleContextAware) {
                    ((MuleContextAware)router).setMuleContext(this.context);
                }
                router.initialise();
                service.getResponseRouter().addRouter(router);
                continue block0;
            }
        }
    }

    protected OutboundRouter processOutboundRouter(Class componentFactoryClass) throws MuleException {
        Collection routerParsers = this.context.getRegistry().lookupObjects(RouterAnnotationParser.class);
        OutboundPassThroughRouter router = null;
        List<AnnotationMetaData> annotations = AnnotationUtils.getClassAndMethodAnnotations(componentFactoryClass);
        block0: for (AnnotationMetaData metaData : annotations) {
            Router routerAnnotation = metaData.getAnnotation().annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.Outbound) continue;
            if (router != null) {
                throw new IllegalStateException("You can onnly configure one outbound router on a service");
            }
            for (RouterAnnotationParser parser : routerParsers) {
                if (!parser.supports(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember())) continue;
                router = (OutboundRouter)parser.parseRouter(metaData.getAnnotation());
                continue block0;
            }
        }
        if (router == null) {
            router = new OutboundPassThroughRouter();
        }
        if (router instanceof MuleContextAware) {
            ((MuleContextAware)router).setMuleContext(this.context);
        }
        router.initialise();
        return router;
    }

    protected void processOutbound(Class componentFactoryClass, Service service) throws MuleException {
        OutboundRouter router = this.processOutboundRouter(componentFactoryClass);
        Reply replyEp = componentFactoryClass.getAnnotation(Reply.class);
        if (replyEp != null) {
            router.setReplyTo(replyEp.uri());
        }
        List<AnnotationMetaData> annotations = AnnotationUtils.getClassAndMethodAnnotations(componentFactoryClass);
        for (AnnotationMetaData annotation : annotations) {
            OutboundEndpoint outboundEndpoint = this.tryOutboundEndpointAnnotation(annotation, ChannelType.Outbound);
            if (outboundEndpoint == null) continue;
            router.addEndpoint(outboundEndpoint);
        }
        if (router instanceof MuleContextAware) {
            ((MuleContextAware)router).setMuleContext(this.context);
        }
        router.initialise();
        service.getOutboundRouter().addRouter((org.mule.api.routing.Router)router);
    }

    protected InboundEndpoint tryInboundEndpointAnnotation(AnnotationMetaData metaData, ChannelType channelType) throws MuleException {
        Channel channelAnno = metaData.getAnnotation().annotationType().getAnnotation(Channel.class);
        if (channelAnno != null && channelAnno.type() == channelType) {
            Collection c = this.context.getRegistry().lookupObjects(EndpointAnnotationParser.class);
            for (EndpointAnnotationParser parser : c) {
                if (!parser.supports(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember())) continue;
                return parser.parseInboundEndpoint(metaData.getAnnotation());
            }
            throw new AnnotationException(AnnotationsMessages.createStaticMessage((String)("No parser found for annotation: " + metaData)));
        }
        return null;
    }

    protected OutboundEndpoint tryOutboundEndpointAnnotation(AnnotationMetaData metaData, ChannelType channelType) throws MuleException {
        Channel channelAnno = metaData.getAnnotation().annotationType().getAnnotation(Channel.class);
        if (channelAnno != null && channelAnno.type() == channelType) {
            Collection c = this.context.getRegistry().lookupObjects(EndpointAnnotationParser.class);
            for (EndpointAnnotationParser parser : c) {
                if (!parser.supports(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember())) continue;
                return parser.parseOutboundEndpoint(metaData.getAnnotation());
            }
        }
        return null;
    }

    protected void processReply(Class componentFactoryClass, Service service) throws MuleException {
        for (int i = 0; i < componentFactoryClass.getAnnotations().length; ++i) {
            Annotation annotation = componentFactoryClass.getAnnotations()[i];
            InboundEndpoint inboundEndpoint = this.tryInboundEndpointAnnotation(new AnnotationMetaData(componentFactoryClass, null, ElementType.TYPE, annotation), ChannelType.Reply);
            if (inboundEndpoint == null) continue;
            service.getResponseRouter().addEndpoint(inboundEndpoint);
        }
        this.processReplyRouters(componentFactoryClass, service);
    }

    protected void processEndpointBindings(Class componentFactoryClass, Service service) throws MuleException {
        Field[] fields = componentFactoryClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isAnnotationPresent(Bind.class)) continue;
            Bind binding = field.getAnnotation(Bind.class);
            AnnotatedEndpointData epd = new AnnotatedEndpointData(MEP.OutIn);
            epd.setConnectorName(binding.connector());
            epd.setAddress(binding.uri());
            DefaultInterfaceBinding router = new DefaultInterfaceBinding();
            router.setInterface(field.getType());
            if (!StringUtils.isBlank((String)binding.method())) {
                router.setMethod(this.getValue(binding.method()));
                for (int j = 0; j < componentFactoryClass.getMethods().length; ++j) {
                    Method m = componentFactoryClass.getMethods()[j];
                    if (!m.getName().equals(router.getMethod())) continue;
                    epd.setMEPUsingMethod(m, false);
                    break;
                }
            }
            router.setEndpoint(this.builder.processEndpoint(epd));
            ((JavaComponent)service.getComponent()).getBindingCollection().addRouter((org.mule.api.routing.Router)router);
        }
    }
}

