/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.PoolingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.annotations.ServiceScope;
import org.mule.object.AbstractObjectFactory;
import org.mule.object.PrototypeObjectFactory;
import org.mule.object.SingletonObjectFactory;

public class ScopedObjectFactory
extends AbstractObjectFactory {
    private ServiceScope scope = ServiceScope.SINGLETON;
    private PoolingProfile poolingProfile;
    private AbstractObjectFactory delegate;
    private Object objectInstance;

    public ServiceScope getScope() {
        return this.scope;
    }

    public void setScope(ServiceScope scope) {
        this.scope = scope;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void initialise() throws InitialisationException {
        if (this.scope == ServiceScope.PROTOTYPE) {
            this.delegate = new PrototypeObjectFactory();
        } else if (this.scope == ServiceScope.SINGLETON) {
            this.delegate = new SingletonObjectFactory();
        } else if (this.scope == ServiceScope.POOLED) {
            this.delegate = new PrototypeObjectFactory();
        } else {
            throw new InitialisationException(CoreMessages.valueIsInvalidFor((String)String.valueOf((Object)this.scope), (String)"scope"), (Initialisable)this);
        }
        this.delegate.setProperties(this.getProperties());
        this.delegate.setObjectClass(this.getObjectClass());
        this.delegate.initialise();
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public boolean isSingleton() {
        return this.scope == ServiceScope.SINGLETON;
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public void setObjectInstance(Object instance) {
        if (!this.isSingleton()) {
            throw new UnsupportedOperationException("cannot set the instance on a non-singleton");
        }
        this.objectInstance = instance;
        this.setObjectClass(instance.getClass());
    }

    public Object getInstance() throws Exception {
        if (this.objectInstance != null) {
            return this.objectInstance;
        }
        return super.getInstance();
    }
}

