/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.msgsimple.source;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.InternalBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.source.MessageSource;

public final class PropertiesMessageSource
implements MessageSource {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Map<String, String> messages = new HashMap<String, String>();

    public static MessageSource fromResource(String resourcePath) throws IOException {
        return PropertiesMessageSource.fromResource(resourcePath, UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageSource fromResource(String resourcePath, Charset charset) throws IOException {
        BUNDLE.checkNotNull(resourcePath, "cfg.nullResourcePath");
        URL url = PropertiesMessageSource.class.getResource(resourcePath);
        if (url == null) {
            throw new IOException(BUNDLE.printf("properties.resource.notFound", resourcePath));
        }
        InputStream in = url.openStream();
        try {
            MessageSource messageSource = PropertiesMessageSource.fromInputStream(in, charset);
            return messageSource;
        }
        finally {
            PropertiesMessageSource.closeQuietly(in);
        }
    }

    public static MessageSource fromFile(File file) throws IOException {
        return PropertiesMessageSource.fromFile(file, UTF8);
    }

    public static MessageSource fromPath(String path) throws IOException {
        BUNDLE.checkNotNull(path, "cfg.nullPath");
        return PropertiesMessageSource.fromFile(new File(path), UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageSource fromFile(File file, Charset charset) throws IOException {
        BUNDLE.checkNotNull(file, "cfg.nullFile");
        FileInputStream in = new FileInputStream(file);
        try {
            MessageSource messageSource = PropertiesMessageSource.fromInputStream(in, charset);
            return messageSource;
        }
        finally {
            PropertiesMessageSource.closeQuietly(in);
        }
    }

    public static MessageSource fromPath(String path, Charset charset) throws IOException {
        BUNDLE.checkNotNull(path, "cfg.nullPath");
        return PropertiesMessageSource.fromFile(new File(path), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MessageSource fromInputStream(InputStream in, Charset charset) throws IOException {
        BUNDLE.checkNotNull(in, "cfg.nullInputStream");
        InputStreamReader reader = new InputStreamReader(in, charset);
        try {
            Properties properties = new Properties();
            properties.load(reader);
            PropertiesMessageSource propertiesMessageSource = new PropertiesMessageSource(properties);
            return propertiesMessageSource;
        }
        finally {
            PropertiesMessageSource.closeQuietly(reader);
        }
    }

    private PropertiesMessageSource(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            this.messages.put(key, properties.getProperty(key));
        }
    }

    @Override
    public String getKey(String key) {
        return this.messages.get(key);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

