/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ListProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.LogLevel;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class DisallowKeywordValidator
extends DraftV3TypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode digested) {
        super("disallow", digested);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType(instance);
        if (this.types.contains((Object)type)) {
            report.error(this.newMsg(data, bundle, "err.draftv3.disallow.type").putArgument("found", type).putArgument("disallowed", DisallowKeywordValidator.toArrayNode(this.types)));
            return;
        }
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        Iterator iterator = this.schemas.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of(this.keyword, index));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.set(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != 0) {
            report.error(this.newMsg(data, bundle, "err.draftv3.disallow.schema").putArgument("matched", nrSuccess).putArgument("nrSchemas", this.schemas.size()).put("reports", (JsonNode)fullReport));
        }
    }
}

