/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal;

import java.net.URI;
import java.net.URL;

public class ValidatorCommonUtils {
    private ValidatorCommonUtils() {
    }

    public static String resolveLocationIfNecessary(String path) {
        URI uri = URI.create(path);
        String scheme = uri.getScheme();
        if (scheme == null || "resource".equals(scheme)) {
            return ValidatorCommonUtils.openSchema(uri.getPath()).toString();
        }
        return path;
    }

    public static URL openSchema(String path) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null && path.startsWith("/") && (url = ValidatorCommonUtils.openSchema(path.substring(1))) != null) {
            return url;
        }
        if (url == null) {
            throw new IllegalArgumentException("Cannot find schema [" + path + "]");
        }
        return url;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

