/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.internal;

import java.io.IOException;
import org.mule.extension.test.internal.toxiproxy.BadProxy;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.execution.Execution;

public class ConnectionTestOperations {
    @Execution(value=ExecutionType.BLOCKING)
    public void createProxy(String realPort, String realHost, String proxyPort) throws ConnectionException {
        try {
            BadProxy.createProxy(realPort, realHost, proxyPort);
        }
        catch (IOException e) {
            throw new ConnectionException("Could not connect to ToxiProxy Server", (Throwable)e);
        }
    }

    @Execution(value=ExecutionType.BLOCKING)
    public void disconnectProxy(String proxyPort) throws ConnectionException {
        try {
            BadProxy.generateConnectivityIssueTo(proxyPort);
        }
        catch (IOException e) {
            throw new ConnectionException("Could not connect to ToxiProxy Server", (Throwable)e);
        }
    }

    @Execution(value=ExecutionType.BLOCKING)
    public void reconnectProxy(String proxyPort) throws ConnectionException {
        try {
            BadProxy.resolveConnectivityIssue(proxyPort);
        }
        catch (IOException e) {
            throw new ConnectionException("Could not connect to ToxiProxy Server", (Throwable)e);
        }
    }

    @Execution(value=ExecutionType.CPU_LITE)
    public void defineProxyServerPort(String serverPort) throws ConnectionException {
        BadProxy.createClientInOtherPort(serverPort);
    }
}

