/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.internal;

import java.io.InputStream;
import java.util.Map;
import org.mule.extension.compression.api.strategy.ArchiverStrategy;
import org.mule.extension.compression.api.strategy.ExtractorStrategy;
import org.mule.extension.compression.internal.error.exception.CompressionException;
import org.mule.extension.compression.internal.error.exception.NullArchiveException;
import org.mule.extension.compression.internal.error.providers.ArchiveErrorProvider;
import org.mule.extension.compression.internal.error.providers.ExtractErrorProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class ArchivingOperations {
    @MediaType(value="*/*", strict=false)
    @Summary(value="Compresses a set of entries into a new file in the specified archive format")
    @Throws(value={ArchiveErrorProvider.class})
    public Result<InputStream, Void> archive(@Content Map<String, TypedValue<InputStream>> entries, @ParameterDsl(allowReferences=false) @Expression(value=ExpressionSupport.NOT_SUPPORTED) ArchiverStrategy archiver) {
        if (entries == null) {
            throw new CompressionException("the entries parameter is null");
        }
        return archiver.archive(entries);
    }

    @MediaType(value="*/*", strict=false)
    @Throws(value={ExtractErrorProvider.class})
    @Streaming
    @Summary(value="Decompresses a compressed content in the configured returning a list with all the entries inside it uncompressed")
    public Map<String, InputStream> extract(@Content TypedValue<InputStream> compressed, @ParameterDsl(allowReferences=false) @Expression(value=ExpressionSupport.NOT_SUPPORTED) ExtractorStrategy extractor, StreamingHelper streamingHelper) {
        if (compressed.getValue() == null) {
            throw new NullArchiveException();
        }
        return streamingHelper.resolveCursorProviders(extractor.extract(compressed), true);
    }
}

