/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.compression.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.Random;
import javax.inject.Inject;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.mule.extension.compression.internal.CompressionExtension;
import org.mule.extension.compression.internal.error.exception.CompressionException;
import org.mule.extension.compression.internal.zip.TempZipFile;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class CompressionManager
implements Startable,
Stoppable {
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final Random RANDOM = new Random();
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private TransformationService transformationService;
    private Scheduler compressionScheduler;

    public void start() throws MuleException {
        this.compressionScheduler = this.schedulerService.cpuIntensiveScheduler();
    }

    public void stop() throws MuleException {
        this.compressionScheduler.stop();
        this.compressionScheduler = null;
    }

    public Result<InputStream, Void> asyncArchive(Map<String, TypedValue<InputStream>> entries) {
        try {
            PipedInputStream pipe = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(pipe);
            this.compressionScheduler.submit(() -> this.archive(entries, out));
            return Result.builder().output((Object)pipe).mediaType(CompressionExtension.ZIP_MEDIA_TYPE).build();
        }
        catch (CompressionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompressionException(t);
        }
    }

    public TempZipFile toTempZip(InputStream inputStream) throws IOException {
        return new TempZipFile(this.toTempFile(inputStream));
    }

    private File toTempFile(InputStream inputStream) throws IOException {
        String fileName = "mule-compression-buffer" + RANDOM.nextLong() + ".tmp";
        File file = new File(TEMP_DIR, fileName);
        FileUtils.copyStreamToFile((InputStream)inputStream, (File)file);
        return file;
    }

    private void archive(Map<String, TypedValue<InputStream>> entries, OutputStream out) {
        try (ZipArchiveOutputStream zip = new ZipArchiveOutputStream(out);){
            entries.forEach((name, content) -> this.addEntry(zip, (String)name, (TypedValue<InputStream>)content, this.transformationService));
        }
        catch (IOException e) {
            throw new CompressionException(e);
        }
    }

    private void addEntry(ZipArchiveOutputStream zip, String name, TypedValue<InputStream> entryContent, TransformationService transformationService) {
        try {
            int length;
            ZipArchiveEntry newEntry = new ZipArchiveEntry(name);
            zip.putArchiveEntry((ArchiveEntry)newEntry);
            byte[] buffer = new byte[1024];
            InputStream content = this.getContent(name, entryContent, transformationService);
            while ((length = content.read(buffer)) >= 0) {
                zip.write(buffer, 0, length);
            }
            zip.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new CompressionException(e);
        }
    }

    private InputStream getContent(String name, TypedValue<?> entryContent, TransformationService transformationService) {
        try {
            Object value = entryContent.getValue();
            if (value instanceof InputStream) {
                return (InputStream)value;
            }
            return (InputStream)transformationService.transform(value, entryContent.getDataType(), DataType.INPUT_STREAM);
        }
        catch (Exception e) {
            throw new CompressionException("cannot archive entry [" + name + "], content cannot be transformed to InputStream");
        }
    }
}

