/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidQueryStringException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.ValidatedQueryParams;
import org.mule.runtime.api.util.MultiMap;

public class QueryStringValidator {
    public static ValidatedQueryParams validate(QueryString queryString, String rawQueryString, MultiMap<String, String> queryParams) throws InvalidQueryStringException {
        if (!QueryStringValidator.shouldProcessQueryString(queryString)) {
            return null;
        }
        Map<String, Parameter> facetsWithDefault = QueryStringValidator.getFacetsWithDefaultValue(queryString.facets());
        MultiMap<String, String> queryParamsCopy = AttributesHelper.copyImmutableMap(queryParams);
        queryParamsCopy.keySet().forEach(facetsWithDefault::remove);
        QueryStringValidator.validateQueryString(queryParamsCopy, queryString);
        return new ValidatedQueryParams(queryParamsCopy, QueryStringValidator.addDefaultValues(facetsWithDefault, queryParamsCopy, rawQueryString));
    }

    private static String addDefaultValues(Map<String, Parameter> facetsWithDefault, MultiMap<String, String> queryParamsCopy, String rawQueryString) {
        for (Map.Entry<String, Parameter> entry : facetsWithDefault.entrySet()) {
            String defaultValue = entry.getValue().getDefaultValue();
            rawQueryString = AttributesHelper.addQueryString(rawQueryString, entry.getKey(), defaultValue);
            queryParamsCopy.put((Object)entry.getKey(), (Object)entry.getValue().getDefaultValue());
        }
        return rawQueryString;
    }

    private static void validateQueryString(MultiMap<String, String> queryParamsCopy, QueryString queryString) throws InvalidQueryStringException {
        if (!queryString.validate(new HashMap(queryParamsCopy.toListValuesMap()))) {
            throw new InvalidQueryStringException("Invalid value for query string");
        }
    }

    private static boolean shouldProcessQueryString(QueryString queryString) {
        return queryString != null && !queryString.isArray() && !queryString.isScalar();
    }

    private static Map<String, Parameter> getFacetsWithDefaultValue(Map<String, Parameter> facets) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Parameter> entry : facets.entrySet()) {
            if (entry.getValue().getDefaultValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

