/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MinimalField;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.LimitedByteArrayOutputStream;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataTextParameter;

public abstract class MultipartEntityBuilder {
    private static Pattern HEADERS_PATTERN = Pattern.compile("([\\w-]+): (.*)");
    protected byte[] preamble;
    protected byte[] epilogue;
    protected long contentLength;
    protected final long sizeLimit;
    protected final String boundary;

    public MultipartEntityBuilder(String boundary, long sizeLimit) {
        this.boundary = boundary;
        this.preamble = new byte[0];
        this.epilogue = new byte[0];
        this.contentLength = 0L;
        this.sizeLimit = sizeLimit;
    }

    public abstract void addDefault(String var1, String var2) throws InvalidFormParameterException;

    public abstract Multipart getOutput();

    protected abstract void addPart(String var1, byte[] var2, String var3, String var4, String var5) throws InvalidFormParameterException;

    public abstract void handleBinaryPart(MultipartStream var1, Parameter var2, String var3, String var4, String var5, String var6) throws InvalidFormParameterException;

    public void handleTextPart(MultipartStream multipartStream, Parameter parameter, String name, String contentType, String fileName, String headers) throws InvalidFormParameterException {
        try {
            byte[] buf = this.partToByteArray(multipartStream);
            if (parameter != null) {
                String body = IOUtils.toString((InputStream)new ByteArrayInputStream(buf));
                new MultipartFormDataTextParameter(body).validate(parameter);
            }
            this.addPart(name, buf, contentType, fileName, headers);
        }
        catch (IOException e) {
            throw new InvalidFormParameterException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidFormParameterException(e.getMessage());
        }
    }

    protected byte[] partToByteArray(MultipartStream stream) throws IOException {
        LimitedByteArrayOutputStream content = new LimitedByteArrayOutputStream(this.sizeLimit);
        stream.readBodyData((OutputStream)content);
        return content.toByteArray();
    }

    protected Map<String, String> getHeaders(String headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = HEADERS_PATTERN.matcher(headers);
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            map.put(name, value);
        }
        return map;
    }

    public void handlePart(MultipartStream multipartStream, Parameter parameter, String name, String contentType, String fileName, String headers) throws InvalidFormParameterException {
        if (parameter != null && parameter.getFileProperties().isPresent()) {
            this.handleBinaryPart(multipartStream, parameter, name, contentType, fileName, headers);
        } else {
            this.handleTextPart(multipartStream, parameter, name, contentType, fileName, headers);
        }
    }

    public void handleBoundary(boolean firstOne) throws InvalidFormParameterException, IOException {
        this.increaseContentLength(firstOne ? (long)(StreamUtils.BOUNDARY_PREFIX.length - 2) : (long)StreamUtils.BOUNDARY_PREFIX.length);
        this.increaseContentLength(this.boundary.length());
    }

    public void handlePreamble(byte[] preamble) throws InvalidFormParameterException {
        this.increaseContentLength(preamble.length);
        this.preamble = preamble;
    }

    public void handleEpilogue(byte[] epilogue) throws InvalidFormParameterException {
        this.increaseContentLength(epilogue.length);
        this.epilogue = epilogue;
    }

    public void handleStreamTermination() throws InvalidFormParameterException {
        this.increaseContentLength(StreamUtils.STREAM_TERMINATOR.length);
    }

    protected void handleFormBodyPart(FormBodyPart formBodyPart) throws InvalidFormParameterException {
        this.increaseContentLength(StreamUtils.CRLF.length);
        for (MinimalField field : formBodyPart.getHeader().getFields()) {
            this.increaseContentLength(field.toString().length() + StreamUtils.CRLF.length);
        }
        this.increaseContentLength(StreamUtils.CRLF.length);
        this.increaseContentLength(formBodyPart.getBody().getContentLength());
    }

    protected void increaseContentLength(long partLength) throws InvalidFormParameterException {
        this.contentLength += partLength;
        if (this.contentLength > this.sizeLimit) {
            throw new InvalidFormParameterException("Multipart content exceeded the maximum size supported");
        }
    }
}

