/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidQueryStringException;
import org.mule.module.apikit.validation.attributes.ValidationUtils;
import org.mule.runtime.api.util.MultiMap;

public class QueryStringValidator {
    public static void validate(QueryString queryString, MultiMap<String, String> queryParams) throws InvalidQueryStringException {
        if (!QueryStringValidator.shouldProcessQueryString(queryString)) {
            return;
        }
        String actualQueryString = QueryStringValidator.buildQueryString(queryString, queryParams);
        if (!queryString.validate(actualQueryString)) {
            throw new InvalidQueryStringException("Invalid value for query string");
        }
    }

    private static boolean shouldProcessQueryString(QueryString queryString) {
        return queryString != null && !queryString.isArray() && !queryString.isScalar();
    }

    private static String buildQueryString(QueryString expected, MultiMap<String, String> queryParams) {
        Parameter facet;
        StringBuilder result = new StringBuilder();
        Map facets = expected.facets();
        Map<String, Parameter> facetsWithDefault = QueryStringValidator.getFacetsWithDefaultValue(facets);
        for (Object property : queryParams.keySet()) {
            facet = (Parameter)facets.get(property.toString());
            facetsWithDefault.remove(property.toString());
            List actualQueryParam = queryParams.getAll((Object)property.toString());
            result.append("\n").append(property).append(": ");
            if (actualQueryParam.size() > 1 || expected.isFacetArray(property.toString())) {
                for (String value : actualQueryParam) {
                    result.append("\n  - ").append(ValidationUtils.escapeAndSurroundWithQuotesIfNeeded(facet, value));
                }
                result.append("\n");
                continue;
            }
            for (String value : actualQueryParam) {
                result.append(ValidationUtils.escapeAndSurroundWithQuotesIfNeeded(facet, value)).append("\n");
            }
        }
        for (Map.Entry<String, Parameter> entry : facetsWithDefault.entrySet()) {
            facet = (Parameter)facets.get(entry.getKey());
            String defaultValue = entry.getValue().getDefaultValue();
            result.append(entry.getKey()).append(": ").append(ValidationUtils.escapeAndSurroundWithQuotesIfNeeded(facet, defaultValue)).append("\n");
        }
        if (result.length() > 0) {
            return result.toString();
        }
        if (expected.getDefaultValue() != null) {
            return expected.getDefaultValue();
        }
        return "{}";
    }

    private static Map<String, Parameter> getFacetsWithDefaultValue(Map<String, Parameter> facets) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Parameter> entry : facets.entrySet()) {
            if (entry.getValue().getDefaultValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

