/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.HeaderName;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;

public class AttributesHelper {
    private static final String ANY_RESPONSE_MEDIA_TYPE = "*/*";

    private AttributesHelper() {
    }

    public static MultiMap<String, String> copyImmutableMap(MultiMap<String, String> immutableMap, String key, String value) {
        MultiMap mapParam = new MultiMap();
        immutableMap.entrySet().stream().forEach(entry -> mapParam.put(entry.getKey(), entry.getValue()));
        mapParam.put((Object)key, (Object)value);
        return mapParam;
    }

    public static String addQueryString(String oldQueryString, String key, String value) {
        String newParam = oldQueryString.length() != 0 ? "&" : "";
        try {
            newParam = newParam + URLEncoder.encode(key, "UTF-8");
            if (value != null) {
                newParam = newParam + "=" + URLEncoder.encode(value, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return oldQueryString + newParam;
    }

    public static HttpRequestAttributes replaceParams(HttpRequestAttributes attributes, MultiMap<String, String> headers, MultiMap<String, String> queryParams, String queryString, Map<String, String> uriParams) {
        return new HttpRequestAttributesBuilder(attributes).headers(headers).queryParams(queryParams).queryString(queryString).uriParams(uriParams).build();
    }

    public static String getHeaderIgnoreCase(HttpRequestAttributes attributes, HeaderName name) {
        return AttributesHelper.getHeaderIgnoreCase(attributes, name.getName());
    }

    public static String getHeaderIgnoreCase(HttpRequestAttributes attributes, String name) {
        MultiMap headers = attributes.getHeaders();
        return AttributesHelper.getParamIgnoreCase((MultiMap<String, String>)headers, name);
    }

    public static String getParamIgnoreCase(MultiMap<String, String> parameters, String name) {
        for (String header : parameters.keySet()) {
            if (!header.equalsIgnoreCase(name.toLowerCase())) continue;
            return (String)parameters.get((Object)header);
        }
        return null;
    }

    public static List<String> getParamsIgnoreCase(MultiMap<String, String> parameters, String name) {
        return parameters.keySet().stream().filter(header -> header.equalsIgnoreCase(name)).findFirst().map(arg_0 -> parameters.getAll(arg_0)).orElse(Collections.emptyList());
    }

    public static String getMediaType(HttpRequestAttributes attributes) {
        String contentType = AttributesHelper.getHeaderIgnoreCase(attributes, HeaderName.CONTENT_TYPE);
        if (contentType != null) {
            return AttributesHelper.getMediaType(contentType);
        }
        return null;
    }

    public static String getMediaType(String mediaType) {
        MediaType mType = MediaType.parse((String)mediaType);
        return String.format("%s/%s", mType.getPrimaryType(), mType.getSubType());
    }

    public static String getAcceptedResponseMediaTypes(MultiMap<String, String> headers) {
        String acceptableResponseMediaTypes = AttributesHelper.getParamIgnoreCase(headers, "accept");
        if (Strings.isNullOrEmpty((String)acceptableResponseMediaTypes)) {
            return ANY_RESPONSE_MEDIA_TYPE;
        }
        return acceptableResponseMediaTypes;
    }
}

