/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.module.apikit.uri.URICoder;

public class UrlUtils {
    private static final String BIND_TO_ALL_INTERFACES = "0.0.0.0";
    public static final String FULL_DOMAIN = "fullDomain";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final Set<Character> ESCAPE_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('{'), Character.valueOf('}')));

    private UrlUtils() {
    }

    private static int getEndOfBasePathIndex(String baseAndApiPath, String requestPath) {
        int index = baseAndApiPath.lastIndexOf(47) + 1;
        return index > requestPath.length() ? requestPath.length() : index;
    }

    public static String encode(String url) {
        return URICoder.encode(url, ESCAPE_CHARS);
    }

    public static String getRelativePath(String baseAndApiPath, String requestPath) {
        int slashLastPosition = baseAndApiPath.lastIndexOf(47);
        return slashLastPosition == -1 || slashLastPosition >= requestPath.length() ? "/" : requestPath.substring(slashLastPosition);
    }

    public static String getListenerPath(String listenerPath, String requestPath) {
        if (!listenerPath.startsWith("/")) {
            listenerPath = "/" + listenerPath;
        }
        if (!requestPath.startsWith("/")) {
            requestPath = "/" + requestPath;
        }
        int slashesAmount = 0;
        for (int i = 0; i < listenerPath.length(); ++i) {
            if (listenerPath.charAt(i) != '/') continue;
            ++slashesAmount;
        }
        String[] split = requestPath.split("/");
        String result = "";
        if (split.length == 0) {
            return "/";
        }
        if (split.length == 1 && split[0].equals("")) {
            return "/";
        }
        for (int i = 0; i < slashesAmount; ++i) {
            if (split[i].equals("")) continue;
            result = result + "/" + split[i];
        }
        return result;
    }

    public static String getBasePath(String baseAndApiPath, String requestPath) {
        int character = UrlUtils.getEndOfBasePathIndex(baseAndApiPath, requestPath);
        return requestPath.substring(0, character);
    }

    public static String replaceBaseUri(String raml, String newBaseUri) {
        if (newBaseUri != null) {
            return UrlUtils.replaceBaseUri(raml, ".*$", newBaseUri);
        }
        return raml;
    }

    private static String replaceBaseUri(String raml, String regex, String replacement) {
        int i;
        Object[] split = raml.split("\n");
        boolean found = false;
        for (i = 0; i < split.length; ++i) {
            if (!split[i].startsWith("baseUri: ")) continue;
            found = true;
            split[i] = ((String)split[i]).replaceFirst(regex, replacement);
            if (((String)split[i]).contains("baseUri: ")) continue;
            split[i] = "baseUri: " + (String)split[i];
        }
        if (!found) {
            for (i = 0; i < split.length; ++i) {
                if (!((String)split[i]).startsWith("title:")) continue;
                split[i] = replacement.contains("baseUri:") ? (String)split[i] + "\n" + replacement : (String)split[i] + "\nbaseUri: " + replacement;
            }
        }
        return StringUtils.join((Object[])split, (String)"\n");
    }

    public static String getRedirectLocation(String scheme, String remoteAddress, String requestPath, String queryString) {
        String redirectLocation = scheme + "://" + remoteAddress + requestPath + "/";
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            redirectLocation = redirectLocation + "?" + queryString;
        }
        return redirectLocation;
    }

    public static String getBaseUriReplacement(String apiServer) {
        return UrlUtils.replaceHostInURL(apiServer, null);
    }

    public static String replaceHostInURL(String routerURL, String consoleRequestHost) {
        String hostToReplace;
        if (routerURL == null) {
            return null;
        }
        if (!routerURL.contains(BIND_TO_ALL_INTERFACES)) {
            return routerURL;
        }
        String string = hostToReplace = System.getProperty(FULL_DOMAIN) != null ? System.getProperty(FULL_DOMAIN) : consoleRequestHost;
        if (hostToReplace == null) {
            return routerURL.replace(BIND_TO_ALL_INTERFACES, "localhost");
        }
        try {
            String protocol = routerURL.contains(HTTPS) ? HTTPS : HTTP;
            String path = new URL(routerURL).getPath();
            String string2 = path = hostToReplace.endsWith("/") && path.length() > 0 ? path.substring(1) : path;
            if (hostToReplace.contains("://")) {
                return hostToReplace + path;
            }
            return protocol + hostToReplace + path;
        }
        catch (MalformedURLException e) {
            return routerURL;
        }
    }
}

