/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import org.mule.apikit.model.MimeType;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.FormValidator;
import org.mule.module.apikit.validation.body.form.MultipartFormValidator;
import org.mule.module.apikit.validation.body.form.UrlencodedFormV1Validator;
import org.mule.module.apikit.validation.body.form.UrlencodedFormV2Validator;
import org.mule.runtime.core.api.el.ExpressionManager;

public class FormValidatorFactory {
    private static final String MULTIPART_FORM = "multipart/";
    private static final String URLENCODED_FORM = "application/x-www-form-urlencoded";
    private final MimeType mimeType;
    private final ExpressionManager expressionManager;

    public FormValidatorFactory(MimeType mimeType, ExpressionManager expressionManager) {
        this.mimeType = mimeType;
        this.expressionManager = expressionManager;
    }

    public FormValidator createValidator(String requestMimeTypeName, boolean isParserV2) throws InvalidFormParameterException {
        if (requestMimeTypeName.contains(MULTIPART_FORM)) {
            return new MultipartFormValidator(this.mimeType.getFormParameters());
        }
        if (requestMimeTypeName.contains(URLENCODED_FORM)) {
            if (isParserV2) {
                return new UrlencodedFormV2Validator(this.mimeType, this.expressionManager);
            }
            return new UrlencodedFormV1Validator(this.mimeType.getFormParameters(), this.expressionManager);
        }
        throw new InvalidFormParameterException("Unsupported mimeType");
    }
}

