/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidQueryStringException;
import org.mule.runtime.api.util.MultiMap;

public class QueryStringValidator {
    private Action action;

    public QueryStringValidator(Action action) {
        this.action = action;
    }

    public void validate(MultiMap<String, String> queryParams) throws InvalidQueryStringException {
        QueryString expected = this.action.queryString();
        if (!this.shouldProcessQueryString(expected)) {
            return;
        }
        String queryString = this.buildQueryString(expected, queryParams);
        if (!expected.validate(queryString)) {
            throw new InvalidQueryStringException("Invalid value for query string");
        }
    }

    private boolean shouldProcessQueryString(QueryString queryString) {
        return queryString != null && !queryString.isArray() && !queryString.isScalar();
    }

    private String buildQueryString(QueryString expected, MultiMap<String, String> queryParams) {
        StringBuilder result = new StringBuilder();
        Map<String, Parameter> facetsWithDefault = this.getFacetsWithDefaultValue(expected.facets());
        for (Object e : queryParams.keySet()) {
            facetsWithDefault.remove(e.toString());
            List actualQueryParam = queryParams.getAll((Object)e.toString());
            result.append("\n").append(e).append(": ");
            if (actualQueryParam.size() > 1 || expected.isFacetArray(e.toString())) {
                for (Object o : actualQueryParam) {
                    result.append("\n  - ").append(o);
                }
                result.append("\n");
                continue;
            }
            for (Object o : actualQueryParam) {
                result.append(o).append("\n");
            }
        }
        for (Map.Entry entry : facetsWithDefault.entrySet()) {
            result.append((String)entry.getKey()).append(": ").append(((Parameter)entry.getValue()).getDefaultValue()).append("\n");
        }
        if (result.length() > 0) {
            return result.toString();
        }
        if (expected.getDefaultValue() != null) {
            return expected.getDefaultValue();
        }
        return "{}";
    }

    private Map<String, Parameter> getFacetsWithDefaultValue(Map<String, Parameter> facets) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Parameter> entry : facets.entrySet()) {
            if (entry.getValue().getDefaultValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

