/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.helpers;

import java.util.HashMap;
import java.util.Map;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.module.apikit.helpers.EventHelper;
import org.mule.module.apikit.helpers.MessageHelper;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpConstants;

public class EventWrapper {
    private CoreEvent inputEvent;
    private CoreEvent.Builder outputBuilder;
    private HashMap<String, String> outboundHeaders = new HashMap();
    private String httpStatus;
    private String outboundHeadersMapName;
    private String httpStatusVarName;

    public EventWrapper(CoreEvent input, String outboundHeadersMapName, String httpStatusVarName) {
        this.inputEvent = input;
        this.outputBuilder = CoreEvent.builder((CoreEvent)input);
        this.outboundHeadersMapName = outboundHeadersMapName;
        this.httpStatusVarName = httpStatusVarName;
        this.httpStatus = String.valueOf(HttpConstants.HttpStatus.OK.getStatusCode());
    }

    public void addOutboundProperties(Map<String, String> headers) {
        this.outboundHeaders.putAll(headers);
    }

    public CoreEvent build() {
        this.outputBuilder.addVariable(this.httpStatusVarName, (Object)this.httpStatus);
        this.outputBuilder.addVariable(this.outboundHeadersMapName, this.outboundHeaders);
        return this.outputBuilder.build();
    }

    public EventWrapper doClientRedirect() {
        this.httpStatus = String.valueOf(HttpConstants.HttpStatus.MOVED_PERMANENTLY.getStatusCode());
        HttpRequestAttributes attributes = EventHelper.getHttpRequestAttributes(this.inputEvent);
        String scheme = attributes.getScheme();
        String remoteAddress = (String)attributes.getHeaders().get((Object)"host");
        String queryString = attributes.getQueryString();
        String requestPath = attributes.getRequestPath();
        String redirectLocation = UrlUtils.getRedirectLocation(scheme, remoteAddress, requestPath, queryString);
        this.outboundHeaders.put("Location", redirectLocation);
        return this;
    }

    public EventWrapper setPayload(Object payload, MediaType mediaType) {
        this.outputBuilder.message(MessageHelper.setPayload(this.inputEvent.getMessage(), payload, mediaType));
        return this;
    }
}

