/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;
import org.mule.apikit.model.parameter.FileProperties;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataParameter;
import org.mule.runtime.api.metadata.MediaType;

public class MultipartFormDataBinaryParameter
implements MultipartFormDataParameter {
    private final int length;
    private final MediaType mediaType;

    public MultipartFormDataBinaryParameter(int length, MediaType mediaType) {
        this.length = length;
        this.mediaType = mediaType;
    }

    @Override
    public void validate(Parameter parameter) throws InvalidFormParameterException {
        Optional fileProperties = parameter.getFileProperties();
        if (!fileProperties.isPresent()) {
            return;
        }
        FileProperties properties = (FileProperties)fileProperties.get();
        Set acceptedFileTypes = properties.getFileTypes();
        Integer minValue = properties.getMinLength();
        Integer maxValue = properties.getMaxLength();
        this.validateMediaType(acceptedFileTypes);
        if (minValue == 0 && maxValue == 0) {
            return;
        }
        if (this.length < minValue || this.length > maxValue) {
            throw new InvalidFormParameterException(String.format("Length must be between : %s and %s", properties.getMinLength(), properties.getMaxLength()));
        }
    }

    private void validateMediaType(Set<String> acceptedMediaTypes) throws InvalidFormParameterException {
        if (acceptedMediaTypes == null || acceptedMediaTypes.isEmpty()) {
            return;
        }
        if (acceptedMediaTypes.contains("*/*")) {
            return;
        }
        if (acceptedMediaTypes.contains(this.mediaType.toString())) {
            return;
        }
        if (acceptedMediaTypes.stream().anyMatch(accepted -> MultipartFormDataBinaryParameter.isCompatible(accepted, this.mediaType))) {
            return;
        }
        throw new InvalidFormParameterException(String.format("Invalid content type: %s", this.mediaType));
    }

    private static boolean isCompatible(String expected, MediaType given) {
        try {
            MimeType acceptedMimeType = new MimeType(expected);
            return MultipartFormDataBinaryParameter.isCompatible(acceptedMimeType, given);
        }
        catch (MimeTypeParseException e) {
            return false;
        }
    }

    private static boolean isCompatible(MimeType expected, MediaType given) {
        String expectedPrimary = expected.getPrimaryType();
        String expectedSub = expected.getSubType();
        String givenPrimary = given.getPrimaryType();
        String givenSub = given.getSubType();
        MimeTypeParameterList parameters = expected.getParameters();
        Enumeration parameterNames = parameters.getNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            String expectedValue = parameters.get(name);
            if (!("charset".equalsIgnoreCase(name) ? !MultipartFormDataBinaryParameter.isSameCharsetOrAlias(expectedValue, given.getCharset().orElse(null)) : !Objects.equals(expectedValue, given.getParameter(name)))) continue;
            return false;
        }
        if (Objects.equals("*", expectedPrimary) && Objects.equals("*", expectedSub)) {
            return true;
        }
        if (Objects.equals(expectedPrimary, givenPrimary) && Objects.equals("*", expectedSub)) {
            return true;
        }
        return Objects.equals(expectedPrimary, givenPrimary) && Objects.equals(expectedSub, givenSub);
    }

    private static boolean isSameCharsetOrAlias(String expectedValue, Charset givenCharset) {
        Charset expectedCharset;
        try {
            expectedCharset = Charset.forName(expectedValue);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return false;
        }
        return Objects.equals(expectedCharset, givenCharset);
    }
}

