/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.regex.Pattern;
import org.mule.module.apikit.uri.URITemplateSyntaxException;
import org.mule.module.apikit.uri.VariableType;

public class Variable {
    private static final Pattern VALID_NAME = Pattern.compile("[a-zA-Z0-9][\\w.-]*");
    protected static final Pattern VALID_VALUE = Pattern.compile("[\\w.~%:-]*");
    private static final String DEFAULT_VALUE = "";
    private Form _form = Form.STRING;
    private VariableType _type;
    private String _name;
    private String _default;

    public Variable(Reserved reserved) throws NullPointerException, IllegalArgumentException {
        this._name = reserved.symbol();
        this._default = DEFAULT_VALUE;
        this._form = Form.STRING;
        this._type = null;
    }

    public Variable(String name, String def) throws NullPointerException, IllegalArgumentException {
        this(name, def, null);
    }

    public Variable(String name, String def, VariableType type) throws NullPointerException, IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("A variable must have a name, but was null");
        }
        if (!Variable.isValidName(name)) {
            throw new IllegalArgumentException("The variable name is not valid: " + name);
        }
        this._name = name;
        this._default = def != null ? def : DEFAULT_VALUE;
        this._type = type;
        this._form = Form.getType(name);
    }

    public Form form() {
        return this._form;
    }

    public String name() {
        return this._name;
    }

    public String defaultValue() {
        return this._default;
    }

    public VariableType type() {
        return this._type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Variable v = (Variable)o;
        return this._name.equals(v._name) && this._default.equals(v._default);
    }

    public int hashCode() {
        return this._name.hashCode() + 7 * this._default.hashCode();
    }

    public String toString() {
        if (this._default.length() > 0) {
            return this._name + '=' + this._default;
        }
        return this._name;
    }

    public static Variable parse(String exp) throws URITemplateSyntaxException {
        int colon;
        Form f = Form.getType(exp);
        if (f != Form.STRING) {
            exp = exp.substring(1);
        }
        if ((colon = exp.indexOf(58)) < 0) {
            Variable v = Variable.parseUntyped(exp);
            v._form = f;
            return v;
        }
        if (colon == 0) {
            Variable v = Variable.parseUntyped(exp.substring(1));
            v._form = f;
            return v;
        }
        Variable v = Variable.parseUntyped(exp.substring(colon + 1));
        v._type = new VariableType(exp.substring(0, colon));
        v._form = f;
        return v;
    }

    private static Variable parseUntyped(String exp) throws URITemplateSyntaxException {
        int equal = exp.indexOf(61);
        if (equal == 0) {
            throw new URITemplateSyntaxException(exp, "Variable name is empty string");
        }
        if (equal > 0) {
            return new Variable(exp.substring(0, equal), exp.substring(equal + 1));
        }
        return new Variable(exp, null);
    }

    public static boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        return VALID_NAME.matcher(name).matches();
    }

    public static boolean isValidValue(String value) {
        if (value == null) {
            return false;
        }
        return VALID_VALUE.matcher(value).matches();
    }

    protected String namePatternString() {
        return this._name.indexOf(46) < 0 ? this._name : this.name().replaceAll("\\.", "\\\\.");
    }

    public static enum Form {
        STRING,
        LIST,
        MAP;


        protected static Form getType(String exp) {
            if (exp.length() == 0) {
                return STRING;
            }
            char c = exp.charAt(0);
            if (c == '@') {
                return LIST;
            }
            if (c == '%') {
                return MAP;
            }
            return STRING;
        }
    }

    public static enum Reserved {
        WILDCARD("*");

        private String _symbol;

        private Reserved(String symbol) {
            this._symbol = symbol;
        }

        String symbol() {
            return this._symbol;
        }
    }
}

