/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.util.List;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWeaveTransformer {
    private static final MediaType MULTIPART_FORMDATA = MediaType.create((String)"multipart", (String)"form-data");
    private static final Logger LOGGER = LoggerFactory.getLogger(DataWeaveTransformer.class);
    private final DataType multiMapDataType = DataType.builder().mapType(MultiMap.class).keyType(String.class).valueType(String.class).build();
    private ExpressionManager expressionManager;

    public DataWeaveTransformer(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public TypedValue runDataWeaveScript(String script, DataType dataType, TypedValue payload) throws InvalidFormParameterException {
        TypedValue result;
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        bindingContextBuilder.addBinding("payload", payload);
        try {
            result = dataType != null ? this.expressionManager.evaluate(script, dataType, bindingContextBuilder.build()) : this.expressionManager.evaluate(script, bindingContextBuilder.build());
        }
        catch (Exception e) {
            LOGGER.error("Invalid form parameter exception. Payload transformation could not be performed. Reason: " + e.getMessage());
            throw new InvalidFormParameterException("Invalid form parameter exception. Payload transformation could not be performed. Reason: " + e.getMessage());
        }
        return result;
    }

    public MultiMap<String, String> getMultiMapFromPayload(TypedValue payload) throws InvalidFormParameterException {
        MediaType mediaType = payload.getDataType().getMediaType();
        String script = mediaType.matches(MULTIPART_FORMDATA) ? "%dw 2.0\nimport try from dw::Runtime\noutput application/java  \n---\n{\n  (payload.parts pluck (value, key) -> do {\n      var defaultWrite = try(() -> write(value.content, value.content.^mimeType) as String)\n      ---\n      {\n        '$key': \n          if (defaultWrite.success)\n            defaultWrite.result\n          else\n             write(value.content, \"application/octet-stream\") as String\n      }\n    })\n}" : "output application/java --- payload";
        MultiMap result = (MultiMap)this.runDataWeaveScript(script, this.multiMapDataType, payload).getValue();
        if (payload.getValue() instanceof RewindableInputStream) {
            ((RewindableInputStream)payload.getValue()).rewind();
        }
        return result;
    }

    public TypedValue getXFormUrlEncodedStream(MultiMap<String, String> mapToTransform, DataType responseDataType) throws InvalidFormParameterException {
        TypedValue modifiedPayload = new TypedValue(mapToTransform, this.multiMapDataType);
        String script = "output application/x-www-form-urlencoded --- payload";
        return this.runDataWeaveScript(script, responseDataType, modifiedPayload);
    }

    public List<String> getKeysFromPayload(TypedValue payload) throws InvalidFormParameterException {
        String script = "output application/java --- payload.parts pluck $$ as String";
        return (List)this.runDataWeaveScript(script, null, payload).getValue();
    }
}

