/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.FormValidatorStrategy;
import org.mule.module.apikit.validation.body.form.transformation.DataWeaveTransformer;
import org.mule.raml.implv2.v10.model.MimeTypeImpl;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.raml.v2.api.model.common.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlencodedFormV2Validator
implements FormValidatorStrategy<TypedValue> {
    protected static final Logger logger = LoggerFactory.getLogger(UrlencodedFormV2Validator.class);
    Map<String, List<IParameter>> formParameters;
    IMimeType actionMimeType;
    DataWeaveTransformer dataWeaveTransformer;

    public UrlencodedFormV2Validator(IMimeType actionMimeType, ExpressionManager expressionManager) {
        this.formParameters = actionMimeType.getFormParameters();
        this.actionMimeType = actionMimeType;
        this.dataWeaveTransformer = new DataWeaveTransformer(expressionManager);
    }

    @Override
    public TypedValue validate(TypedValue originalPayload) throws BadRequestException {
        String jsonText;
        if (!(this.actionMimeType instanceof MimeTypeImpl)) {
            return originalPayload;
        }
        MultiMap<String, String> requestMap = this.dataWeaveTransformer.getMultiMapFromPayload(originalPayload);
        try {
            jsonText = new ObjectMapper().disableDefaultTyping().writeValueAsString(requestMap);
        }
        catch (Exception e) {
            logger.warn("Cannot validate url-encoded form", (Throwable)e);
            return originalPayload;
        }
        List validationResult = ((MimeTypeImpl)this.actionMimeType).validate(jsonText);
        if (validationResult.size() > 0) {
            String resultString = "";
            for (ValidationResult result : validationResult) {
                resultString = resultString + result.getMessage() + "\n";
            }
            throw new InvalidFormParameterException(resultString);
        }
        return this.dataWeaveTransformer.getXFormUrlEncodedStream(requestMap, originalPayload.getDataType());
    }
}

