/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parser;

import java.io.InputStream;
import org.mule.module.apikit.injector.RamlUpdater;
import org.mule.module.apikit.parser.ParserWrapper;
import org.mule.module.apikit.parser.ParserWrapperV1;
import org.mule.module.apikit.parser.ParserWrapperV2;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.interfaces.model.IRaml;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserService {
    private static final Logger logger = LoggerFactory.getLogger(ParserService.class);
    private final String ramlPath;
    private ResourceLoader resourceLoaderV2;
    private ParserWrapper parserWrapper;
    private boolean parserV2;

    public ParserService(String ramlPath) {
        this.ramlPath = ramlPath;
        this.resourceLoaderV2 = new DefaultResourceLoader();
        this.checkParserVersion();
        this.setupParserWrapper(ramlPath);
    }

    public boolean isParserV2() {
        return this.parserV2;
    }

    private void checkParserVersion() {
        InputStream content = this.resourceLoaderV2.fetchResource(this.ramlPath);
        if (content != null) {
            String dump = StreamUtils.toString((InputStream)content);
            this.parserV2 = ParserV2Utils.useParserV2((String)dump);
        }
        logger.debug("Using parser " + (this.parserV2 ? "V2" : "V1"));
    }

    private void setupParserWrapper(String ramlPath) {
        this.parserWrapper = this.parserV2 ? new ParserWrapperV2(ramlPath) : new ParserWrapperV1(ramlPath);
    }

    public void validateRaml() {
        this.parserWrapper.validate();
    }

    public IRaml build() {
        return this.parserWrapper.build();
    }

    public RamlUpdater getRamlUpdater(IRaml api) {
        return this.parserWrapper.getRamlUpdater(api);
    }

    public String dumpRaml(String ramlContent, IRaml api, String oldSchemeHostPort, String newSchemeHostPort) {
        return this.parserWrapper.dump(ramlContent, api, oldSchemeHostPort, newSchemeHostPort);
    }

    public String dumpRaml(IRaml api, String newBaseUri) {
        return this.parserWrapper.dump(api, newBaseUri);
    }

    public String dumpRaml(IRaml api) {
        return this.parserWrapper.dump(api, null);
    }

    public void updateBaseUri(IRaml api, String baseUri) {
        this.parserWrapper.updateBaseUri(api, baseUri);
    }
}

