/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v1.io;

import org.mule.module.apikit.validation.body.schema.v1.io.JsonSchemaResource;
import org.mule.module.apikit.validation.body.schema.v1.io.XmlSchemaResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SchemaResourceLoader
extends DefaultResourceLoader {
    public static final String JSON_SCHEMA_PREFIX = "jsonschema:";
    public static final String XML_SCHEMA_PREFIX = "xmlschema:";

    public SchemaResourceLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (location.startsWith(JSON_SCHEMA_PREFIX)) {
            return new JsonSchemaResource(location.substring(JSON_SCHEMA_PREFIX.length()), this.getClassLoader());
        }
        if (location.startsWith(XML_SCHEMA_PREFIX)) {
            return new XmlSchemaResource(location.substring(XML_SCHEMA_PREFIX.length()), this.getClassLoader());
        }
        return super.getResource(location);
    }
}

