/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.validation.ApiKitJsonSchema;
import org.mule.module.apikit.api.validation.ValidBody;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.module.apikit.input.stream.RewindableInputStream;
import org.mule.module.apikit.validation.body.form.FormParametersValidator;
import org.mule.module.apikit.validation.body.form.MultipartFormValidator;
import org.mule.module.apikit.validation.body.form.UrlencodedFormV1Validator;
import org.mule.module.apikit.validation.body.form.UrlencodedFormV2Validator;
import org.mule.module.apikit.validation.body.schema.IRestSchemaValidatorStrategy;
import org.mule.module.apikit.validation.body.schema.v1.RestJsonSchemaValidator;
import org.mule.module.apikit.validation.body.schema.v1.RestXmlSchemaValidator;
import org.mule.module.apikit.validation.body.schema.v1.cache.SchemaCacheUtils;
import org.mule.module.apikit.validation.body.schema.v2.RestSchemaV2Validator;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyValidator {
    protected static final Logger logger = LoggerFactory.getLogger(BodyValidator.class);

    public static ValidBody validate(IAction action, HttpRequestAttributes attributes, Object payload, ValidationConfig config, String charset) throws BadRequestException, UnsupportedMediaTypeException {
        ValidBody validBody = new ValidBody(payload);
        if (action == null || !action.hasBody()) {
            logger.debug("=== no body types defined: accepting any request content-type");
            return validBody;
        }
        String requestMimeTypeName = AttributesHelper.getMediaType(attributes);
        Map.Entry foundMimeType = action.getBody().entrySet().stream().peek(entry -> {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("comparing request media type %s with expected %s\n", requestMimeTypeName, entry.getKey()));
            }
        }).filter(entry -> ((String)entry.getKey()).equals(requestMimeTypeName)).findFirst().orElseThrow(UnsupportedMediaTypeException::new);
        IMimeType mimeType = (IMimeType)foundMimeType.getValue();
        if (requestMimeTypeName.contains("json") || requestMimeTypeName.contains("xml")) {
            validBody = BodyValidator.validateAsString(config, mimeType, action, requestMimeTypeName, payload, charset);
        } else if (requestMimeTypeName.contains("multipart/form-data") || requestMimeTypeName.contains("application/x-www-form-urlencoded")) {
            validBody = BodyValidator.validateAsMultiPart(config, mimeType, requestMimeTypeName, payload);
        }
        return validBody;
    }

    private static ValidBody validateAsString(ValidationConfig config, IMimeType mimeType, IAction action, String requestMimeTypeName, Object payload, String charset) throws BadRequestException {
        IRestSchemaValidatorStrategy validator = null;
        if (config.isParserV2()) {
            validator = new RestSchemaV2Validator(mimeType);
        } else {
            String schemaPath = SchemaCacheUtils.getSchemaCacheKey(action, requestMimeTypeName);
            try {
                if (requestMimeTypeName.contains("json")) {
                    ApiKitJsonSchema schema = config.getJsonSchema(schemaPath);
                    validator = new RestJsonSchemaValidator(schema != null ? schema.getSchema() : null);
                } else if (requestMimeTypeName.contains("xml")) {
                    validator = new RestXmlSchemaValidator(config.getXmlSchema(schemaPath));
                }
            }
            catch (ExecutionException e) {
                throw new BadRequestException(e);
            }
        }
        if (validator == null) {
            throw new BadRequestException(String.format("Unexpected Mime Type %s", requestMimeTypeName));
        }
        ValidBody validBody = new ValidBody(payload);
        if (payload instanceof InputStream) {
            RewindableInputStream rewindableInputStream = new RewindableInputStream((InputStream)payload);
            validBody.setPayload(rewindableInputStream);
        }
        validator.validate(PayloadHelper.getPayloadAsString(validBody.getPayload(), charset));
        return validBody;
    }

    private static ValidBody validateAsMultiPart(ValidationConfig config, IMimeType mimeType, String requestMimeTypeName, Object payload) throws BadRequestException {
        ValidBody validBody = new ValidBody(payload);
        TypedValue payloadAsTypedValue = validBody.getPayloadAsTypedValue();
        if (mimeType.getFormParameters() != null) {
            if (requestMimeTypeName.contains("multipart/form-data")) {
                FormParametersValidator formParametersValidator = new FormParametersValidator(new MultipartFormValidator(mimeType.getFormParameters(), config.getExpressionManager()));
                validBody.setFormParameters(formParametersValidator.validate(payloadAsTypedValue));
            } else if (requestMimeTypeName.contains("application/x-www-form-urlencoded")) {
                FormParametersValidator formParametersValidator = config.isParserV2() ? new FormParametersValidator(new UrlencodedFormV2Validator(mimeType, config.getExpressionManager())) : new FormParametersValidator(new UrlencodedFormV1Validator(mimeType.getFormParameters(), config.getExpressionManager()));
                validBody.setFormParameters(formParametersValidator.validate(payloadAsTypedValue));
            }
        }
        return validBody;
    }
}

