/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.github.fge.jsonschema.main.JsonSchema;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.xml.validation.Schema;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.ApikitRegistry;
import org.mule.module.apikit.FlowFinder;
import org.mule.module.apikit.FlowMappings;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.config.ConsoleConfig;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.api.validation.ApiKitJsonSchema;
import org.mule.module.apikit.validation.body.schema.v1.cache.JsonSchemaCacheLoader;
import org.mule.module.apikit.validation.body.schema.v1.cache.XmlSchemaCacheLoader;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements Initialisable,
ValidationConfig,
ConsoleConfig {
    private boolean disableValidations;
    private boolean queryParamsStrictValidation;
    private boolean headersStrictValidation;
    private String name;
    private String raml;
    private boolean keepRamlBaseUri;
    private String outboundHeadersMapName;
    private String httpStatusVarName;
    private FlowMappings flowMappings = new FlowMappings();
    private static final String DEFAULT_OUTBOUND_HEADERS_MAP_NAME = "outboundHeaders";
    private static final String DEFAULT_HTTP_STATUS_VAR_NAME = "httpStatus";
    protected LoadingCache<String, URIResolver> uriResolverCache;
    protected LoadingCache<String, URIPattern> uriPatternCache;
    private LoadingCache<String, JsonSchema> jsonSchemaCache;
    private LoadingCache<String, Schema> xmlSchemaCache;
    private static final int URI_CACHE_SIZE = 1000;
    protected static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private RamlHandler ramlHandler;
    private FlowFinder flowFinder;
    @Inject
    private MuleContext muleContext;
    @Inject
    private ApikitRegistry registry;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ConfigurationComponentLocator locator;

    public void initialise() throws InitialisationException {
        try {
            this.ramlHandler = new RamlHandler(this.raml, this.keepRamlBaseUri, this.muleContext);
        }
        catch (IOException e) {
            throw new InitialisationException(e.fillInStackTrace(), (Initialisable)this);
        }
        this.flowFinder = new FlowFinder(this.ramlHandler, this.getName(), this.locator, this.flowMappings.getFlowMappings());
        this.buildResourcePatternCaches();
        this.registry.registerConfiguration(this);
        ApikitErrorTypes.initialise(this.muleContext);
    }

    @Deprecated
    public String getApiServer() {
        return "http://localhost:8081";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRaml() {
        return this.raml;
    }

    public void setRaml(String raml) {
        this.raml = raml;
    }

    public boolean isDisableValidations() {
        return this.disableValidations;
    }

    public void setDisableValidations(boolean disableValidations) {
        this.disableValidations = disableValidations;
    }

    @Override
    public boolean isQueryParamsStrictValidation() {
        return this.queryParamsStrictValidation;
    }

    public void setQueryParamsStrictValidation(boolean queryParamsStrictValidation) {
        this.queryParamsStrictValidation = queryParamsStrictValidation;
    }

    @Override
    public boolean isHeadersStrictValidation() {
        return this.headersStrictValidation;
    }

    public void setHeadersStrictValidation(boolean headersStrictValidation) {
        this.headersStrictValidation = headersStrictValidation;
    }

    public boolean isKeepRamlBaseUri() {
        return this.keepRamlBaseUri;
    }

    public void setKeepRamlBaseUri(boolean keepRamlBaseUri) {
        this.keepRamlBaseUri = keepRamlBaseUri;
    }

    public FlowMappings getFlowMappings() {
        return this.flowMappings;
    }

    public void setFlowMappings(FlowMappings flowMappings) {
        this.flowMappings = flowMappings;
    }

    public String getOutboundHeadersMapName() {
        if (this.outboundHeadersMapName == null) {
            return DEFAULT_OUTBOUND_HEADERS_MAP_NAME;
        }
        return this.outboundHeadersMapName;
    }

    public void setOutboundHeadersMapName(String outboundHeadersMapName) {
        this.outboundHeadersMapName = outboundHeadersMapName;
    }

    public String getHttpStatusVarName() {
        if (this.httpStatusVarName == null) {
            return DEFAULT_HTTP_STATUS_VAR_NAME;
        }
        return this.httpStatusVarName;
    }

    public void setHttpStatusVarName(String httpStatusVarName) {
        this.httpStatusVarName = httpStatusVarName;
    }

    private void buildResourcePatternCaches() {
        logger.info("Building resource URI cache...");
        this.uriResolverCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIResolver>(){

            public URIResolver load(String path) throws IOException {
                return new URIResolver(path);
            }
        });
        this.uriPatternCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIPattern>(){

            public URIPattern load(String path) throws Exception {
                URIResolver resolver = (URIResolver)Configuration.this.uriResolverCache.get((Object)path);
                URIPattern match = Configuration.this.flowFinder.findBestMatch(resolver);
                if (match == null) {
                    logger.warn("No matching patterns for URI " + path);
                    throw new IllegalStateException("No matching patterns for URI " + path);
                }
                return match;
            }
        });
    }

    public FlowFinder getFlowFinder() {
        return this.flowFinder;
    }

    public LoadingCache<String, URIPattern> getUriPatternCache() {
        return this.uriPatternCache;
    }

    public LoadingCache<String, URIResolver> getUriResolverCache() {
        return this.uriResolverCache;
    }

    public LoadingCache<String, JsonSchema> getJsonSchemaCache() {
        if (this.jsonSchemaCache == null) {
            this.jsonSchemaCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new JsonSchemaCacheLoader(this.ramlHandler.getApi()));
        }
        return this.jsonSchemaCache;
    }

    public LoadingCache<String, Schema> getXmlSchemaCache() {
        if (this.xmlSchemaCache == null) {
            LoadingCache transformerCache;
            this.xmlSchemaCache = transformerCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new XmlSchemaCacheLoader(this.ramlHandler.getApi()));
        }
        return this.xmlSchemaCache;
    }

    public void setRamlHandler(RamlHandler ramlHandler) {
        this.ramlHandler = ramlHandler;
    }

    @Override
    public RamlHandler getRamlHandler() {
        return this.ramlHandler;
    }

    @Override
    public boolean isParserV2() {
        return this.getRamlHandler().isParserV2();
    }

    @Override
    public ApiKitJsonSchema getJsonSchema(String schemaPath) throws ExecutionException {
        try {
            return new ApiKitJsonSchema((JsonSchema)this.getJsonSchemaCache().get((Object)schemaPath));
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }

    @Override
    public Schema getXmlSchema(String schemaPath) throws ExecutionException {
        return (Schema)this.getXmlSchemaCache().get((Object)schemaPath);
    }

    @Override
    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }
}

