/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import java.util.Map;
import org.mule.module.apikit.api.exception.InvalidUriParameterException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.api.util.MultiMap;

public class UriParametersValidator {
    MultiMap<String, String> uriParams;
    IResource resource;
    ResolvedVariables resolvedVariables;

    public UriParametersValidator(IResource resource, ResolvedVariables resolvedVariables) {
        this.resource = resource;
        this.resolvedVariables = resolvedVariables;
    }

    public MultiMap<String, String> validateAndAddDefaults(Map<String, String> uriParams) throws InvalidUriParameterException {
        String value;
        this.uriParams = new MultiMap(uriParams);
        for (Map.Entry entry : this.resource.getResolvedUriParameters().entrySet()) {
            value = (String)this.resolvedVariables.get((String)entry.getKey());
            IParameter uriParameter = (IParameter)entry.getValue();
            if (uriParameter.validate(value)) continue;
            String msg = String.format("Invalid value '%s' for uri parameter %s. %s", value, entry.getKey(), uriParameter.message(value));
            throw new InvalidUriParameterException(msg);
        }
        for (String name : this.resolvedVariables.names()) {
            value = String.valueOf(this.resolvedVariables.get(name));
            this.uriParams = AttributesHelper.addParam(this.uriParams, name, value);
        }
        return this.uriParams;
    }
}

