/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.HeadersValidator;
import org.mule.module.apikit.validation.attributes.QueryParameterValidator;
import org.mule.module.apikit.validation.attributes.UriParametersValidator;
import org.mule.raml.interfaces.model.IResource;
import org.mule.runtime.api.util.MultiMap;

public class AttributesValidator {
    public static HttpRequestAttributes validateAndAddDefaults(HttpRequestAttributes attributes, IResource resource, ResolvedVariables resolvedVariables, ValidationConfig config) throws MuleRestException {
        UriParametersValidator uriParametersValidator = new UriParametersValidator(resource, resolvedVariables);
        MultiMap<String, String> uriParams = uriParametersValidator.validateAndAddDefaults(attributes.getUriParams());
        QueryParameterValidator queryParamValidator = new QueryParameterValidator(resource.getAction(attributes.getMethod().toLowerCase()));
        queryParamValidator.validateAndAddDefaults((MultiMap<String, String>)attributes.getQueryParams(), attributes.getQueryString(), config.isQueryParamsStrictValidation());
        MultiMap<String, String> queryParams = queryParamValidator.getQueryParams();
        String queryString = queryParamValidator.getQueryString();
        HeadersValidator headersValidator = new HeadersValidator();
        headersValidator.validateAndAddDefaults((MultiMap<String, String>)attributes.getHeaders(), resource.getAction(attributes.getMethod().toLowerCase()), config.isHeadersStrictValidation());
        MultiMap<String, String> headers = headersValidator.getNewHeaders();
        return AttributesHelper.replaceParams(attributes, headers, queryParams, queryString, uriParams);
    }
}

