/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api.uri;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.mule.module.apikit.uri.Matchable;
import org.mule.module.apikit.uri.Token;
import org.mule.module.apikit.uri.TokenLiteral;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URITemplate;

public class URIPattern
extends URITemplate
implements Matchable {
    private static final Set<Character> ESCAPE_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('{'), Character.valueOf('}')));
    private Pattern _pattern;
    private int _score = -1;

    public URIPattern(String template, boolean encode) throws IllegalArgumentException {
        super(encode ? URICoder.encode(template, ESCAPE_CHARS) : template);
        if (!URIPattern.isMatchable(this)) {
            throw new IllegalArgumentException("Cannot create a URL pattern containing non-matchable tokens.");
        }
        this._pattern = this.computePattern(this.tokens());
    }

    public URIPattern(String template) throws IllegalArgumentException {
        this(template, true);
    }

    public URIPattern(URITemplate template) throws IllegalArgumentException {
        super(template != null ? template.toString() : "");
        if (template == null) {
            throw new NullPointerException("Cannot create a URL pattern with a null template");
        }
        if (!URIPattern.isMatchable(template)) {
            throw new IllegalArgumentException("Cannot create a URL pattern from template containing non-matchable tokens.");
        }
        this._pattern = this.computePattern(this.tokens());
    }

    public static boolean isMatchable(URITemplate template) {
        for (Token t : template.tokens()) {
            if (t instanceof Matchable) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean match(String uri) {
        return this._pattern.matcher(uri).matches();
    }

    @Override
    public Pattern pattern() {
        return this._pattern;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return 7 * this._pattern.pattern().hashCode() + 3 * this.toString().hashCode() + 31;
    }

    protected int score() {
        if (this._score < 0) {
            this._score = this.computeScore(this.tokens());
        }
        return this._score;
    }

    private Pattern computePattern(List<Token> tokens) {
        StringBuffer p = new StringBuffer();
        for (Token t : tokens) {
            Matchable mt = (Matchable)((Object)t);
            p.append('(');
            p.append(mt.pattern());
            p.append(')');
        }
        return Pattern.compile(p.toString());
    }

    private int computeScore(List<Token> tokens) {
        int score = 0;
        for (Token t : tokens) {
            if (!(t instanceof TokenLiteral)) continue;
            score += t.expression().length();
        }
        return score;
    }
}

