/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api.console;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.api.config.ConsoleConfig;
import org.mule.module.apikit.api.console.ConsoleResource;
import org.mule.module.apikit.api.console.RamlResource;
import org.mule.module.apikit.api.console.Resource;
import org.mule.module.apikit.exception.NotFoundException;

public class ConsoleResources {
    private static final String CONSOLE_RESOURCES_BASE = "/console-resources";
    private static final String ROOT_CONSOLE_PATH = "/";
    private static final String INDEX_RESOURCE_RELATIVE_PATH = "/index.html";
    private static final String RAML_LOCATION_PLACEHOLDER_KEY = "RAML_LOCATION_PLACEHOLDER";
    private ConsoleConfig config;
    private String listenerPath;
    private String requestPath;
    private String queryString;
    private String method;
    private String aceptHeader;

    public ConsoleResources(ConsoleConfig config, String listenerPath, String requestPath, String queryString, String method, String aceptHeader) {
        this.config = config;
        this.listenerPath = listenerPath;
        this.requestPath = requestPath;
        this.queryString = queryString;
        this.method = method;
        this.aceptHeader = aceptHeader;
    }

    public Resource getConsoleResource(String resourceRelativePath) {
        ConsoleResource consoleResource;
        String consoleResourcePath;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block8: {
            String raml = this.getRamlResourceIfRequested(resourceRelativePath);
            if (raml != null) {
                return new RamlResource(raml);
            }
            inputStream = null;
            byteArrayOutputStream = null;
            consoleResourcePath = resourceRelativePath.equals(ROOT_CONSOLE_PATH) ? "/console-resources/index.html" : CONSOLE_RESOURCES_BASE + resourceRelativePath;
            inputStream = this.getClass().getResourceAsStream(consoleResourcePath);
            if (inputStream != null) break block8;
            raml = this.config.getRamlHandler().getRamlV2(resourceRelativePath);
            if (raml == null) {
                throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath));
            }
            RamlResource ramlResource = new RamlResource(raml);
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
            return ramlResource;
        }
        try {
            if (consoleResourcePath.contains("index.html")) {
                inputStream = this.updateIndexWithRamlLocation(inputStream);
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            consoleResource = new ConsoleResource(byteArrayOutputStream.toByteArray(), consoleResourcePath);
        }
        catch (IOException e) {
            try {
                throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(byteArrayOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        return consoleResource;
    }

    private InputStream updateIndexWithRamlLocation(InputStream inputStream) throws IOException {
        String ramlLocation = this.config.getRamlHandler().isParserV2() ? this.config.getRamlHandler().getRootRamlLocationForV2() : this.config.getRamlHandler().getRootRamlLocationForV1();
        String indexHtml = IOUtils.toString((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        indexHtml = indexHtml.replaceFirst(RAML_LOCATION_PLACEHOLDER_KEY, ramlLocation);
        inputStream = new ByteArrayInputStream(indexHtml.getBytes());
        return inputStream;
    }

    public void isValidPath(String listenerPath) {
        if (listenerPath != null && !listenerPath.endsWith("/*")) {
            throw new IllegalStateException("Console path in listener must end with /*");
        }
    }

    public String getRamlResourceIfRequested(String resourceRelativePath) {
        if (this.config.getRamlHandler().isRequestingRamlV1ForConsole(this.listenerPath, this.requestPath, this.queryString, this.method, this.aceptHeader)) {
            return this.config.getRamlHandler().getRamlV1();
        }
        if (this.config.getRamlHandler().isRequestingRamlV2(this.listenerPath, this.requestPath, this.queryString, this.method)) {
            return this.config.getRamlHandler().getRamlV2(resourceRelativePath);
        }
        return null;
    }
}

