/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.storage.info;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mule.extension.aggregator.internal.storage.content.AggregatedContent;
import org.mule.extension.aggregator.internal.storage.info.AggregatorSharedInformation;
import org.mule.extension.aggregator.internal.task.AsyncTask;

public class GroupAggregatorSharedInformation
implements AggregatorSharedInformation {
    private static final long serialVersionUID = 5216802662481396417L;
    private Map<String, AggregatedContent> contentMap = new HashMap<String, AggregatedContent>();
    private Map<String, AsyncTask> registeredEvictions = new HashMap<String, AsyncTask>();
    private Map<String, AsyncTask> registeredTimeouts = new HashMap<String, AsyncTask>();

    public AggregatedContent getAggregatedContent(String groupId) {
        return this.contentMap.get(groupId);
    }

    public void setAggregatedContent(String groupId, AggregatedContent content) {
        this.contentMap.put(groupId, content);
    }

    public void removeAggregatedContent(String groupId) {
        this.contentMap.remove(groupId);
    }

    public boolean shouldRegisterEviction(String groupId) {
        return this.registeredEvictions.get(groupId) == null;
    }

    public void registerGroupEvictionTask(String groupId, AsyncTask groupEvictionTask) {
        this.registeredEvictions.put(groupId, groupEvictionTask);
    }

    public void unregisterGroupEvictionTask(String groupId) {
        this.registeredEvictions.remove(groupId);
    }

    public Map<String, AsyncTask> getRegisteredGroupEvictionTasks() {
        return this.registeredEvictions;
    }

    public boolean shouldRegisterTimeout(String groupId) {
        return this.registeredTimeouts.get(groupId) == null;
    }

    public void registerTimeoutAsyncAggregation(String groupId, AsyncTask timeoutTask) {
        this.registeredTimeouts.put(groupId, timeoutTask);
    }

    public void unregisterTimeoutAsyncAggregation(String groupId) {
        this.registeredTimeouts.remove(groupId);
    }

    public Map<String, AsyncTask> getRegisteredTimeoutAsyncAggregations() {
        return this.registeredTimeouts;
    }

    @Override
    @Deprecated
    public boolean upgradeIfNeeded() {
        boolean hasChanges = false;
        for (AggregatedContent aggregatedContent : this.contentMap.values()) {
            if (Objects.isNull(aggregatedContent)) continue;
            hasChanges = hasChanges || aggregatedContent.upgradeIfNeeded();
        }
        return hasChanges;
    }
}

