/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aggregator.internal.source;

import javax.inject.Inject;
import org.mule.extension.aggregator.api.AggregationAttributes;
import org.mule.extension.aggregator.api.stereotype.AggregatorStereotype;
import org.mule.extension.aggregator.internal.config.AggregatorManager;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public class AggregatorListener
extends Source<Message, AggregationAttributes> {
    private final Object startLock = new Object();
    @Inject
    private AggregatorManager manager;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @AllowedStereotypes(value={AggregatorStereotype.class})
    private String aggregatorName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="false")
    private boolean includeTimedOutGroups;
    private Boolean started = false;
    private SourceCallback<Message, AggregationAttributes> sourceCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(SourceCallback<Message, AggregationAttributes> sourceCallback) throws MuleException {
        Object object = this.startLock;
        synchronized (object) {
            this.sourceCallback = sourceCallback;
            this.manager.registerListener(this.aggregatorName, this);
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop() {
        Object object = this.startLock;
        synchronized (object) {
            this.started = false;
            this.manager.unregisterListener(this.aggregatorName, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.startLock;
        synchronized (object) {
            return this.started;
        }
    }

    public SourceCallback getCallback() {
        return this.sourceCallback;
    }

    public boolean shouldIncludeTimedOutGroups() {
        return this.includeTimedOutGroups;
    }
}

