/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.function;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.api.exception.WrongTypeModuleException;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.parameters.MethodIdentifier;
import org.mule.extensions.java.internal.util.JavaExceptionUtils;
import org.mule.extensions.java.internal.util.JavaModuleUtils;
import org.mule.extensions.java.internal.util.MethodInvoker;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaModuleFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaModuleFunctions.class);
    @Inject
    private JavaModuleLoadingCache cache;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExpressionManager expressionManager;

    public Object invoke(@Alias(value="class") @Summary(value="Fully qualified name of the Class containing the referenced Method") String clazz, @Alias(value="method") @Summary(value="Represents the Method signature containing the method name and it's argument types.") String methodName, Object instance, @Optional Map<String, TypedValue<Object>> args) throws NoSuchMethodModuleException, ClassNotFoundModuleException, WrongTypeModuleException, ArgumentMismatchModuleException, InvocationModuleException {
        Map<String, TypedValue<Object>> resolvedArgs = args == null ? Collections.emptyMap() : args.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> TypedValue.of(e.getValue())));
        JavaModuleUtils.validateType(clazz, instance, true, this.cache);
        MethodIdentifier identifier = new MethodIdentifier(clazz, methodName);
        Method method = this.cache.getMethod(identifier, instance.getClass(), resolvedArgs, false);
        return MethodInvoker.invokeMethod(method, resolvedArgs, instance, identifier, this.transformationService, this.expressionManager, LOGGER);
    }

    public boolean isInstanceOf(Object instance, @Alias(value="class") @Summary(value="Fully qualified name of the Class you want to check against") String clazz) throws ClassNotFoundModuleException {
        return ClassUtils.isInstance(this.cache.loadClass(clazz), (Object)instance);
    }

    public Throwable getRootCause(Throwable exception) {
        return JavaExceptionUtils.getRootCause(exception);
    }

    public boolean isCausedBy(Throwable exception, @Summary(value="Fully qualified name of the Class you want to check against") String throwableType, @Optional boolean includeSubtypes) {
        return JavaExceptionUtils.isCausedBy(exception, this.cache.loadClass(throwableType), includeSubtypes);
    }
}

