/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.api.exception;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.extensions.java.api.error.JavaModuleError;
import org.mule.extensions.java.api.exception.JavaModuleException;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifierFactory;
import org.mule.extensions.java.internal.parameters.MethodIdentifier;
import org.mule.extensions.java.internal.parameters.StaticMethodIdentifier;
import org.mule.extensions.java.internal.util.JavaModuleUtils;
import org.mule.runtime.api.metadata.TypedValue;

public class NoSuchMethodModuleException
extends JavaModuleException {
    public NoSuchMethodModuleException(ExecutableIdentifier id, Class<?> targetClass, Map<String, TypedValue<Object>> args) {
        super(NoSuchMethodModuleException.buildMessage(id, targetClass, JavaModuleUtils.toHumanReadableArgs(args)), JavaModuleError.NO_SUCH_METHOD);
    }

    private static String buildMessage(ExecutableIdentifier id, Class<?> targetClass, List<String> args) {
        LinkedList staticMethods = new LinkedList();
        LinkedList instanceMethods = new LinkedList();
        Arrays.stream(targetClass.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).map(ExecutableIdentifierFactory::create).forEach(m -> {
            if (m instanceof StaticMethodIdentifier) {
                staticMethods.add(m.getElementId());
            } else {
                instanceMethods.add(m.getElementId());
            }
        });
        StringBuilder sb = new StringBuilder().append("No public ").append(id.getExecutableTypeName()).append(" found with signature '").append(id.getElementId()).append("' for Class '").append(id.getClazz()).append("'.");
        if (!staticMethods.isEmpty()) {
            sb.append("\nPublic static Methods are ").append(staticMethods);
        } else if (id instanceof StaticMethodIdentifier) {
            sb.append("\nThere are no public static Methods declared in Class ").append(id.getClazz()).append(".");
        }
        if (!instanceMethods.isEmpty()) {
            sb.append("\nPublic instance Methods are ").append(instanceMethods);
        } else if (id instanceof MethodIdentifier) {
            sb.append("\nThere are no public Methods declared in Class ").append(id.getClazz()).append(".");
        }
        return sb.toString();
    }
}

